/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.sql;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import team.bangbang.common.config.Config;

public final class SQLPool {
    private static boolean useDatabase = Config.getProperty("application.druid.url") != null;
    private static boolean autocommit = false;
    private static String databaseName = null;
    private static Map<String, DataSource> dsMap = null;
    public static final String DB_ALIAS = "ApplicationName";

    public static Connection getConnection() throws SQLException {
        return SQLPool.getConnection("application");
    }

    public static DataSource getDataSource() throws SQLException {
        return SQLPool.getDataSource("application");
    }

    public static String getDatabaseName() {
        if (!useDatabase) {
            return null;
        }
        if (databaseName != null) {
            return databaseName;
        }
        Connection conn = null;
        try {
            conn = SQLPool.getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            databaseName = dmd.getDatabaseProductName();
        }
        catch (SQLException ex) {
            databaseName = "";
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return databaseName;
    }

    public static Connection getConnection(String alias) throws SQLException {
        if (!useDatabase) {
            return null;
        }
        DataSource ds = SQLPool.getDataSource(alias);
        if (ds == null) {
            return null;
        }
        Connection c = ds.getConnection();
        if (c.getAutoCommit() != autocommit) {
            c.setAutoCommit(autocommit);
        }
        c.setTransactionIsolation(2);
        return c;
    }

    public static DataSource getDataSource(String alias) {
        if (!useDatabase) {
            return null;
        }
        if (dsMap == null) {
            dsMap = new HashMap<String, DataSource>();
        }
        DataSource ds = dsMap.get(alias);
        return ds;
    }

    private static void configure() throws SQLException {
        List<Properties> lstConfig = SQLPool.getDatabaseProperties();
        if (dsMap == null) {
            dsMap = new HashMap<String, DataSource>();
        }
        for (int i = 0; i < lstConfig.size(); ++i) {
            Properties dc = lstConfig.get(i);
            DruidDataSource dds = new DruidDataSource();
            dds.configFromPropety(dc);
            String alias = dc.getProperty("druid.name");
            dsMap.put(alias, (DataSource)dds);
        }
    }

    private static List<Properties> getDatabaseProperties() {
        ArrayList<Properties> lstConfig = new ArrayList<Properties>();
        Enumeration<String> er = Config.keys();
        ArrayList<String> lstAlias = new ArrayList<String>();
        while (er != null && er.hasMoreElements()) {
            String alias;
            String key = er.nextElement();
            int nIndex = key.indexOf(".druid.");
            if (nIndex < 0 || lstAlias.contains(alias = key.substring(0, nIndex))) continue;
            lstAlias.add(alias);
        }
        for (int i = 0; i < lstAlias.size(); ++i) {
            String alias = (String)lstAlias.get(i);
            Properties dc = new Properties();
            dc.setProperty("druid.name", alias);
            dc.setProperty("druid.url", Config.getProperty(alias + ".druid.url"));
            dc.setProperty("druid.driverClassName", Config.getProperty(alias + ".druid.driver-class"));
            dc.setProperty("druid.username", Config.getProperty(alias + ".druid.username"));
            dc.setProperty("druid.password", Config.getProperty(alias + ".druid.password"));
            dc.setProperty("druid.initialSize", Config.getProperty(alias + ".druid.initial-size"));
            dc.setProperty("druid.minIdle", Config.getProperty(alias + ".druid.min-idle"));
            dc.setProperty("druid.maxActive", Config.getProperty(alias + ".druid.max-active"));
            dc.setProperty("druid.maxWaitThreadCount", Config.getProperty(alias + ".druid.maxWait"));
            dc.setProperty("druid.timeBetweenEvictionRunsMillis", Config.getProperty(alias + ".druid.timeBetweenEvictionRunsMillis"));
            dc.setProperty("druid.minEvictableIdleTimeMillis", Config.getProperty(alias + ".druid.minEvictableIdleTimeMillis"));
            dc.setProperty("druid.validationQuery", Config.getProperty(alias + ".druid.validationQuery"));
            dc.setProperty("druid.testWhileIdle", Config.getProperty(alias + ".druid.testWhileIdle"));
            dc.setProperty("druid.testOnBorrow", Config.getProperty(alias + ".druid.testOnBorrow"));
            dc.setProperty("druid.testOnReturn", Config.getProperty(alias + ".druid.testOnReturn"));
            lstConfig.add(dc);
        }
        return lstConfig;
    }

    static {
        try {
            if (useDatabase) {
                SQLPool.configure();
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }
}

