/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.sql.generator;

import java.sql.SQLException;
import java.util.UUID;
import team.bangbang.common.data.RecordData;
import team.bangbang.common.sql.SQLHelper;
import team.bangbang.common.sql.generator.TableKey;
import team.bangbang.common.sql.generator.TableKeyMetaData;
import team.bangbang.common.utility.LogicUtility;

public final class IDGenerator {
    public static synchronized void generateId(SQLHelper db, RecordData wd) throws SQLException {
        String tableName = wd.getTable();
        TableKey tk = TableKeyMetaData.getTableKey(db.getAlias(), tableName);
        String pkName = tk.getKeyName();
        if (wd.getSingleData(pkName) != null) {
            return;
        }
        Object objNextId = IDGenerator.getNextId(db, tk);
        if (objNextId == null) {
            throw new SQLException("\u5173\u952e\u5b57\u7684\u503c\u5df2\u7ecf\u8d85\u51fa\u8303\u56f4\uff01");
        }
        wd.setSingleData(pkName, objNextId);
    }

    private static synchronized Object getNextId(SQLHelper db, TableKey tk) throws SQLException {
        if ("char".equalsIgnoreCase(tk.getKeyType()) && tk.getKeyLength() == 36) {
            return UUID.randomUUID().toString();
        }
        String pkName = tk.getKeyName();
        String tableName = tk.getTableName();
        String sql = "SELECT MAX(" + pkName + ") AS MaxId FROM " + tableName;
        RecordData wdTemp = new RecordData();
        db.querySingleData(sql, wdTemp);
        String maxId = wdTemp.getSingleString("MaxId");
        if (maxId == null || maxId.trim().length() == 0) {
            tk.setCurrentKeyNumber(0L);
        } else if (tk.getKeyType().indexOf("CHAR") >= 0) {
            tk.setCurrentKeyNumber(LogicUtility.parseLong(maxId.substring(tk.getPrefix().length()), 0L));
        } else {
            tk.setCurrentKeyNumber(LogicUtility.parseLong(maxId, 0L));
        }
        return tk.getNextKeyValue();
    }
}

