/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.sql.generator;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import team.bangbang.common.config.Config;
import team.bangbang.common.exception.BizException;
import team.bangbang.common.sql.SQLPool;
import team.bangbang.common.sql.generator.TableKey;

public class TableKeyMetaData {
    private static Map<String, Map<String, TableKey>> keys = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(String alias) {
        if (keys == null) {
            keys = new HashMap<String, Map<String, TableKey>>();
        }
        HashMap<String, TableKey> mp = new HashMap<String, TableKey>();
        keys.put(alias, mp);
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = SQLPool.getConnection(alias);
            String catalog = conn.getCatalog();
            DatabaseMetaData dmd = conn.getMetaData();
            String schema = TableKeyMetaData.getSchema(dmd, alias);
            String[] types = new String[]{"TABLE"};
            rs = dmd.getTables(catalog, schema, "%", types);
            if (rs != null) {
                while (rs.next()) {
                    TableKey tk = new TableKey();
                    String tableName = rs.getString("TABLE_NAME");
                    tk.setTableName(tableName);
                    mp.put(tableName.toUpperCase(), tk);
                }
                rs.close();
            }
            if (mp.isEmpty()) {
                throw new BizException("\u6ca1\u6709\u627e\u5230\u6709\u6548\u7684\u6570\u636e\u5e93Schema\u5bf9\u8c61\uff08" + schema + "\uff09\uff01\u53ef\u4ee5\u8bbe\u5b9a\u7cfb\u7edf\u53c2\u6570{[alia].druid.schema}\u6216\u8005\u66f4\u6539\u6570\u636e\u5e93\u8fde\u63a5\u7528\u6237\u540d\u6307\u5b9aSchema\u3002");
            }
            Iterator it = mp.keySet().iterator();
            while (it != null && it.hasNext()) {
                String pkName;
                Object objKey = it.next();
                TableKey tk = (TableKey)mp.get(objKey);
                String tableName = tk.getTableName();
                String prefix = TableKeyMetaData.getPrefix(tableName);
                tk.setPrefix(prefix);
                rs = dmd.getPrimaryKeys(catalog, schema, tableName);
                if (rs != null) {
                    if (rs.next()) {
                        pkName = rs.getString("COLUMN_NAME");
                        tk.setKeyName(pkName);
                    }
                    rs.close();
                }
                if ((rs = dmd.getColumns(catalog, schema, tableName, pkName = tk.getKeyName())) == null) continue;
                if (rs.next()) {
                    tk.setKeyType(rs.getString("TYPE_NAME").toUpperCase());
                    tk.setKeyLength(rs.getInt("COLUMN_SIZE"));
                }
                rs.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static TableKey getTableKey(String alias, String tableName) {
        Map<String, TableKey> mp;
        if (keys == null || keys.isEmpty() || keys.get(alias) == null) {
            TableKeyMetaData.initialize(alias);
        }
        if ((mp = keys.get(alias)) == null) {
            return null;
        }
        return mp.get(tableName.toUpperCase());
    }

    public static Set<String> getTables(String alias) {
        Map<String, TableKey> mp;
        if (keys == null || keys.isEmpty() || keys.get(alias) == null) {
            TableKeyMetaData.initialize(alias);
        }
        if ((mp = keys.get(alias)) == null) {
            return null;
        }
        return mp.keySet();
    }

    private static String getPrefix(String tableName) {
        String suffix;
        int nIndex = tableName.lastIndexOf("_");
        if (nIndex < 0) {
            nIndex = tableName.lastIndexOf("8");
        }
        if ("BASE".equals(suffix = tableName.substring(nIndex + 1).toUpperCase()) || "MASTER".equals(suffix)) {
            nIndex = tableName.indexOf("_");
            if (nIndex < 0) {
                nIndex = tableName.indexOf("8");
            }
            return tableName.substring(nIndex + 1, nIndex + 2).toUpperCase();
        }
        return String.valueOf(suffix.charAt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSchema(DatabaseMetaData dmd, String alias) {
        String schema = Config.getProperty(alias + ".druid.schema");
        if (schema == null) {
            String username = Config.getProperty(alias + ".druid.username");
            ResultSet rs = null;
            try {
                rs = dmd.getSchemas();
                while (rs != null && rs.next()) {
                    String temp = rs.getString(1);
                    if (temp == null || !temp.equalsIgnoreCase(username)) continue;
                    schema = temp;
                    break;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (schema != null && schema.trim().length() == 0) {
            schema = null;
        }
        return schema;
    }
}

