/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.utility;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.UUID;

public final class LogicUtility {
    private static NumberFormat nf = NumberFormat.getNumberInstance(Locale.CHINA);

    public static boolean isNumber(String strValue) {
        if (strValue == null || strValue.trim().length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(strValue);
        }
        catch (Exception ex1) {
            return false;
        }
        try {
            Double.parseDouble(strValue);
        }
        catch (Exception ex1) {
            return false;
        }
        return true;
    }

    public static int parseInt(String strValue, int nDefaultValue) {
        return (int)LogicUtility.parseDouble(strValue, nDefaultValue);
    }

    public static long parseLong(String strValue, long lDefaultValue) {
        try {
            lDefaultValue = Long.parseLong(strValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lDefaultValue;
    }

    public static double parseDouble(String strValue, double dblDefaultValue) {
        try {
            dblDefaultValue = Double.parseDouble(strValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dblDefaultValue;
    }

    public static Color parseColor(String strRgb, Color defaultColor) {
        if (strRgb == null || strRgb.length() != 7) {
            return defaultColor;
        }
        strRgb = strRgb.substring(1);
        int rgb = -1;
        try {
            rgb = Integer.parseInt(strRgb, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return rgb < 0 ? defaultColor : new Color(rgb);
    }

    public static String getTimeAsString() {
        return LogicUtility.getTimeAsString(new Date());
    }

    public static String getTimeAsString(Date date) {
        if (date == null) {
            return "";
        }
        Calendar objDate = Calendar.getInstance();
        if (date != null) {
            objDate.setTime(date);
        }
        String strDate = objDate.get(1) + "-" + LogicUtility.to2Digits(objDate.get(2) + 1) + "-" + LogicUtility.to2Digits(objDate.get(5)) + " " + LogicUtility.to2Digits(objDate.get(11)) + ":" + LogicUtility.to2Digits(objDate.get(12)) + ":" + LogicUtility.to2Digits(objDate.get(13));
        objDate = null;
        return strDate;
    }

    private static String to2Digits(int n) {
        return n < 10 ? "0" + n : String.valueOf(n);
    }

    public static long getTimeInMillis(String strTime) {
        long lTime = 0L;
        try {
            strTime = strTime.trim();
            if (strTime.indexOf(" ") > 0) {
                throw new Exception("Time format must be yyyy-mm-dd or yyyy/dd/mm");
            }
            String str = "-";
            int nIndex = strTime.indexOf(str);
            if (nIndex < 0) {
                str = "/";
                nIndex = strTime.indexOf(str);
            }
            int nYear = Integer.parseInt(strTime.substring(0, nIndex));
            strTime = strTime.substring(nIndex + 1);
            nIndex = strTime.indexOf(str);
            int nMonth = Integer.parseInt(strTime.substring(0, nIndex));
            if (--nMonth < 0) {
                --nYear;
                nMonth = 11;
            }
            int nDay = Integer.parseInt(strTime.substring(nIndex + 1));
            Calendar objDate = Calendar.getInstance();
            objDate.clear();
            objDate.set(nYear, nMonth, nDay);
            lTime = objDate.getTime().getTime();
            objDate = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lTime;
    }

    public static String getDateAsString() {
        return LogicUtility.getDateAsString(new Date());
    }

    public static String getDateAsString(Date date) {
        if (date == null) {
            return "";
        }
        Calendar objDate = Calendar.getInstance();
        if (date != null) {
            objDate.setTime(date);
        }
        String strDate = objDate.get(1) + "-" + LogicUtility.to2Digits(objDate.get(2) + 1) + "-" + LogicUtility.to2Digits(objDate.get(5));
        objDate = null;
        return strDate;
    }

    public static String getYearMonth(Date date) {
        Calendar objDate = Calendar.getInstance();
        objDate.setTime(date);
        String strDate = String.valueOf(objDate.get(1)) + LogicUtility.to2Digits(objDate.get(2) + 1);
        return strDate;
    }

    public static Date parseDate(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        str = str.replace('/', '-');
        String[] sa = (str = str.replace('\\', '-')).split("\\s+");
        if (sa == null || sa.length == 0) {
            return null;
        }
        String s1 = null;
        String s2 = null;
        if (sa.length == 1) {
            if (sa[0].indexOf(":") > 0) {
                s2 = sa[0];
            } else {
                s1 = sa[0];
            }
        }
        if (sa.length >= 2) {
            for (int i = 0; sa != null && i < 2 && i < sa.length; ++i) {
                if (sa[i].indexOf(":") > 0 || s1 != null) {
                    s2 = sa[i];
                    continue;
                }
                s1 = sa[i];
            }
        }
        if (s1 == null) {
            s1 = "1900-01-01";
        }
        if (s2 == null) {
            s2 = "00:00:00";
        }
        int[] ymd = LogicUtility.getYmd(s1);
        int[] hms = LogicUtility.getHms(s2);
        Calendar cal = Calendar.getInstance();
        cal.set(ymd[0], ymd[1] - 1, ymd[2], hms[0], hms[1], hms[2]);
        return cal.getTime();
    }

    private static int[] getHms(String s2) {
        int[] hms = new int[]{0, 0, 0};
        int nEnd = s2.indexOf(":");
        if (nEnd < 0) {
            hms[0] = LogicUtility.parseInt(s2, hms[0]);
            return hms;
        }
        int nStart = 0;
        hms[0] = LogicUtility.parseInt(s2.substring(nStart, nEnd), hms[0]);
        nStart = nEnd + 1;
        if (nStart >= s2.length()) {
            return hms;
        }
        nEnd = s2.indexOf(":", nStart);
        if (nEnd < 0) {
            hms[1] = LogicUtility.parseInt(s2.substring(nStart), hms[1]);
            nEnd = s2.length();
        } else {
            hms[1] = LogicUtility.parseInt(s2.substring(nStart, nEnd), hms[1]);
        }
        nStart = nEnd + 1;
        if (nStart >= s2.length()) {
            return hms;
        }
        hms[2] = LogicUtility.parseInt(s2.substring(nStart), hms[2]);
        return hms;
    }

    private static int[] getYmd(String s1) {
        int[] ymd = new int[]{1900, 1, 1};
        int nEnd = s1.indexOf("-");
        if (nEnd < 0) {
            ymd[0] = LogicUtility.parseInt(s1, ymd[0]);
            return ymd;
        }
        int nStart = 0;
        ymd[0] = LogicUtility.parseInt(s1.substring(nStart, nEnd), ymd[0]);
        nStart = nEnd + 1;
        if (nStart >= s1.length()) {
            return ymd;
        }
        nEnd = s1.indexOf("-", nStart);
        if (nEnd < 0) {
            ymd[1] = LogicUtility.parseInt(s1.substring(nStart), ymd[1]);
            nEnd = s1.length();
        } else {
            ymd[1] = LogicUtility.parseInt(s1.substring(nStart, nEnd), ymd[1]);
        }
        nStart = nEnd + 1;
        if (nStart >= s1.length()) {
            return ymd;
        }
        ymd[2] = LogicUtility.parseInt(s1.substring(nStart), ymd[2]);
        return ymd;
    }

    public static boolean isSameDay(Date dateA, Date dateB) {
        if (dateA == null || dateB == null) {
            return false;
        }
        Calendar objDateA = Calendar.getInstance();
        objDateA.setTime(dateA);
        Calendar objDateB = Calendar.getInstance();
        objDateB.setTime(dateB);
        if (objDateA.get(1) != objDateB.get(1)) {
            return false;
        }
        if (objDateA.get(2) != objDateB.get(2)) {
            return false;
        }
        return objDateA.get(5) == objDateB.get(5);
    }

    public static String getDataString(String strValue) {
        String dbName = "";
        return LogicUtility.getDataString(strValue, dbName);
    }

    public static String getDataString(String strValue, String dbName) {
        StringBuffer stbResult = new StringBuffer("");
        if (strValue != null && strValue.length() > 0) {
            for (int i = 0; i < strValue.length(); ++i) {
                if (strValue.charAt(i) == '\'') {
                    stbResult.append("''");
                    continue;
                }
                if (strValue.charAt(i) == '\\' && dbName.equalsIgnoreCase("MySQL")) {
                    stbResult.append("\\\\");
                    continue;
                }
                if (strValue.charAt(i) == '&' && dbName.equalsIgnoreCase("Oracle")) {
                    stbResult.append("'||'&'||'");
                    continue;
                }
                stbResult.append(strValue.charAt(i));
            }
            return stbResult.toString();
        }
        return "";
    }

    public static String duplicateString(String strValue, int nUnit) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < nUnit; ++i) {
            sb.append(strValue);
        }
        return sb.toString();
    }

    public static String[] splitString(String strValue, String strDelim) {
        if (strValue == null || strDelim == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(strValue, strDelim);
        String[] arrResult = new String[st.countTokens()];
        for (int i = 0; i < arrResult.length; ++i) {
            arrResult[i] = st.nextToken();
        }
        return arrResult;
    }

    public static String formatNumber(double dbValue, int nFraction) {
        nf.setMaximumFractionDigits(nFraction);
        return nf.format(dbValue);
    }

    public static String formatNumber(String strValue, int nFraction) {
        return LogicUtility.formatNumber(LogicUtility.parseDouble(strValue, 0.0), nFraction);
    }

    public static String getQuotedString(String strValue) {
        StringBuffer stbResult = new StringBuffer("");
        if (strValue != null && strValue.length() > 0) {
            block7: for (int i = 0; i < strValue.length(); ++i) {
                switch (strValue.charAt(i)) {
                    case '&': {
                        stbResult.append("&amp;");
                        continue block7;
                    }
                    case '<': {
                        stbResult.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        stbResult.append("&gt;");
                        continue block7;
                    }
                    case '\"': {
                        stbResult.append("&quot;");
                        continue block7;
                    }
                    case '\\': {
                        stbResult.append("\\\\");
                        continue block7;
                    }
                    default: {
                        stbResult.append(strValue.charAt(i));
                    }
                }
            }
            return stbResult.toString();
        }
        return "";
    }

    public static String getHTMLString(String strValue) {
        StringBuffer stbResult = new StringBuffer("");
        int cLast = 32;
        for (int i = 0; strValue != null && i < strValue.length(); ++i) {
            switch (strValue.charAt(i)) {
                case '&': {
                    stbResult.append("&amp;");
                    break;
                }
                case '<': {
                    stbResult.append("&lt;");
                    break;
                }
                case '>': {
                    stbResult.append("&gt;");
                    break;
                }
                case ' ': {
                    if (cLast == 32) {
                        stbResult.append("&nbsp;");
                        break;
                    }
                    stbResult.append(" ");
                    break;
                }
                case '\"': {
                    stbResult.append("&quot;");
                    break;
                }
                case '\r': {
                    stbResult.append("<br/>");
                    break;
                }
                case '\n': {
                    if (cLast == 13) break;
                    stbResult.append("<br>");
                    break;
                }
                case '\t': {
                    stbResult.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    break;
                }
                default: {
                    stbResult.append(strValue.charAt(i));
                }
            }
            cLast = strValue.charAt(i);
        }
        return stbResult.toString();
    }

    public static String changeHTMLLineSpace(String strValue) {
        StringBuffer stbResult = new StringBuffer("");
        int cLast = 32;
        if (strValue != null && strValue.length() > 0) {
            for (int i = 0; i < strValue.length(); ++i) {
                switch (strValue.charAt(i)) {
                    case ' ': {
                        if (cLast == 32) {
                            stbResult.append("&nbsp;");
                            break;
                        }
                        stbResult.append(" ");
                        break;
                    }
                    case '\r': {
                        if (cLast == 62) break;
                        stbResult.append("<br/>");
                        break;
                    }
                    case '\n': {
                        if (cLast == 13 || cLast == 62) break;
                        stbResult.append("<br/>");
                        break;
                    }
                    case '\t': {
                        stbResult.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                        break;
                    }
                    default: {
                        stbResult.append(strValue.charAt(i));
                    }
                }
                cLast = strValue.charAt(i);
            }
        } else {
            stbResult.append("&nbsp;");
        }
        return stbResult.toString();
    }

    public static String getCNString(String strValue) {
        if (strValue == null) {
            return null;
        }
        try {
            byte[] temp = strValue.getBytes("ISO-8859-1");
            return new String(temp, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static byte[] readInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = null;
        byte[] result = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] buff = new byte[512];
            int nLen = 0;
            while ((nLen = is.read(buff)) > 0) {
                baos.write(buff, 0, nLen);
            }
            result = baos.toByteArray();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static String getOrSQL(String fieldName, Object[] ids) {
        if (ids == null || ids.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            Object obj = ids[i];
            if (obj == null) continue;
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append(fieldName).append(" = ");
            if (obj instanceof String) {
                sb.append("'").append(obj).append("'");
                continue;
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    public static String getSegmentString(String strValue, int nMaxLen) {
        int i;
        if (strValue == null || nMaxLen <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int nLen = strValue.length();
        char c = ' ';
        int hasGet = 0;
        for (i = 0; i < nLen; ++i) {
            c = strValue.charAt(i);
            hasGet = c > '\u00ff' ? (hasGet += 2) : ++hasGet;
            if (hasGet > nMaxLen) break;
            sb.append(c);
        }
        if (i < nLen) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static InputStream getResourceAsStream(String resource) throws IOException {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = LogicUtility.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = LogicUtility.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new IOException(resource + " not found");
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFile(File src, File dest) {
        if (src == null || dest == null) {
            return false;
        }
        File dir = dest.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        byte[] buff = new byte[512];
        int len = 0;
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(src);
            os = new FileOutputStream(dest, false);
            int loopTimes = 0;
            while ((len = ((InputStream)is).read(buff)) > 0) {
                os.write(buff, 0, len);
                if (++loopTimes <= 0 || loopTimes / 1024 != 0) continue;
                os.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
        return src.delete();
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        int nIndex = fileName.lastIndexOf(".");
        return nIndex >= 0 ? fileName.substring(nIndex + 1) : "";
    }

    public static String toDigitString(int n, int len) {
        String s = String.valueOf(n);
        while (s.length() < len) {
            s = "0" + s;
        }
        return s;
    }

    public static String toDigitString(long n, int len) {
        String s = String.valueOf(n);
        while (s.length() < len) {
            s = "0" + s;
        }
        return s;
    }

    public static String toAsciiString(String v) {
        if (v == null || v.length() == 0) {
            return v;
        }
        StringBuffer sb = new StringBuffer();
        char[] cs = v.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] < '\u0080') {
                sb.append(cs[i]);
                continue;
            }
            String temp = Integer.toHexString(cs[i] & 0xFFFFFFFF);
            while (temp.length() < 4) {
                temp = "0" + temp;
            }
            sb.append("\\u").append(temp);
        }
        return sb.toString();
    }

    public static String getRandomNumber(int length) {
        String serial = "0123456789";
        Random random = new Random();
        int n = serial.length();
        StringBuffer code = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            code.append(serial.charAt(random.nextInt(n)));
        }
        return code.toString();
    }

    public static synchronized String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getRandomString(int length) {
        String codeSerial = "1234567890abcdefghkmnpqrstwxyABCDEFGHKLMNPQRSTWXY";
        Random random = new Random();
        int n = codeSerial.length();
        StringBuffer code = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            code.append(codeSerial.charAt(random.nextInt(n)));
        }
        return code.toString();
    }

    public static boolean isEmpty(String test) {
        return test == null || test.trim().length() == 0;
    }

    public static boolean isNotEmpty(String test) {
        return test != null && test.trim().length() != 0;
    }
}

