/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import team.bangbang.common.utility.TreeNode;

public final class TreeUtil {
    private static final String TEMPORARY_FLAG = TreeUtil.class.getName() + " TEMPORARY FLAG";

    private TreeUtil() {
    }

    public static TreeNode[] toTrees(List<TreeNode> nodes) {
        int i;
        if (nodes == null) {
            return null;
        }
        ArrayList<TreeNode> lstTop = new ArrayList<TreeNode>();
        TreeNode[] temp = new TreeNode[nodes.size()];
        nodes.toArray(temp);
        for (i = 0; i < temp.length; ++i) {
            TreeNode node = temp[i];
            boolean blTop = true;
            for (int j = 0; j < nodes.size(); ++j) {
                if (i == j) continue;
                TreeNode node2 = temp[j];
                if (node.getParentId() != null && node.getParentId().equals(node2.getId())) {
                    blTop = false;
                }
                node2 = null;
                if (!blTop) break;
            }
            if (blTop) {
                lstTop.add(node);
            }
            node = null;
        }
        for (i = 0; i < lstTop.size(); ++i) {
            nodes.remove(lstTop.get(i));
        }
        TreeNode[] sons = new TreeNode[lstTop.size()];
        for (int i2 = 0; i2 < lstTop.size(); ++i2) {
            sons[i2] = (TreeNode)lstTop.get(i2);
            sons[i2].addSons(TreeUtil.getSons(nodes, sons[i2].getId()));
        }
        lstTop = null;
        return sons;
    }

    public static TreeNode findNode(TreeNode tree, Object objId) {
        if (tree == null || tree.getId() == null) {
            return null;
        }
        if (tree.getId().equals(objId)) {
            return tree;
        }
        if (!tree.hasSon()) {
            return null;
        }
        TreeNode[] sons = tree.getSons();
        for (int i = 0; i < sons.length; ++i) {
            TreeNode t = TreeUtil.findNode(sons[i], objId);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static Collection<Object> getSelfAndSonIds(TreeNode tree) {
        if (tree == null) {
            return null;
        }
        HashSet<Object> ids = new HashSet<Object>();
        TreeUtil.saveSelfAndSonIds(tree, ids);
        return ids;
    }

    public static Collection<Object> getSelfAndSonIds(TreeNode tree, Collection<Object> ids) {
        if (tree == null || ids == null || ids.size() == 0) {
            return null;
        }
        HashSet<Object> resultIds = new HashSet<Object>();
        for (Object id : ids) {
            TreeNode node;
            if (id == null || id instanceof Long && (Long)id == 0L || id instanceof Integer && (Integer)id == 0 || (node = TreeUtil.findNode(tree, id)) == null) continue;
            resultIds.add(id);
            Collection<Object> objs = TreeUtil.getSelfAndSonIds(node);
            if (objs == null || objs.isEmpty()) continue;
            resultIds.addAll(objs);
        }
        return resultIds;
    }

    public static TreeNode insertNode(TreeNode tree, TreeNode node) {
        if (node == null) {
            return tree;
        }
        if (tree == null) {
            return node;
        }
        TreeNode father = TreeUtil.findNode(tree, node.getParentId());
        if (father == null) {
            return tree;
        }
        TreeNode[] temp = new TreeNode[]{node};
        father.addSons(temp);
        father.sortSons();
        return tree;
    }

    public static TreeNode updateNode(TreeNode tree, TreeNode node) {
        if (tree == null || node == null) {
            return tree;
        }
        TreeNode old = TreeUtil.findNode(tree, node.getId());
        if (old == null) {
            return tree;
        }
        if (tree.equals(old)) {
            return node;
        }
        node.addSons(old.getSons());
        Boolean obj1 = old.getActiveFlag();
        Boolean obj2 = node.getActiveFlag();
        if (obj1 == null || !obj1.equals(obj2)) {
            TreeUtil.setActiveFlag(node, obj2);
        }
        TreeNode oldFather = TreeUtil.findNode(tree, old.getParentId());
        oldFather.removeSon(old);
        TreeUtil.insertNode(tree, node);
        return tree;
    }

    public static TreeNode deleteNode(TreeNode tree, TreeNode node) {
        if (tree == null || node == null) {
            return tree;
        }
        TreeNode old = TreeUtil.findNode(tree, node.getId());
        if (old == null) {
            return tree;
        }
        if (tree.equals(old)) {
            return null;
        }
        TreeNode oldFather = TreeUtil.findNode(tree, old.getParentId());
        oldFather.removeSon(old);
        return tree;
    }

    public static TreeNode[] filterWithoutAncestor(TreeNode tree, Collection<? extends Object> ids) {
        if (tree == null || ids == null || ids.size() == 0) {
            return null;
        }
        TreeNode[] result = null;
        if (ids.contains(tree.getId())) {
            result = new TreeNode[]{tree};
            return result;
        }
        if (tree.hasSon()) {
            TreeNode[] sons = tree.getSons();
            for (int i = 0; i < sons.length; ++i) {
                result = TreeUtil.appendArray(result, TreeUtil.filterWithoutAncestor(sons[i], ids));
            }
        }
        return result;
    }

    public static TreeNode filterWithAncestor(TreeNode tree, Collection<? extends Object> ids) {
        return TreeUtil.filterWithAncestor(tree, ids, true);
    }

    public static TreeNode filterWithAncestor(TreeNode tree, Collection<? extends Object> ids, boolean retainSon) {
        if (tree == null || ids == null || ids.size() == 0) {
            return null;
        }
        if (retainSon) {
            TreeUtil.markFamily(null, tree, ids);
        } else {
            for (Object object : ids) {
                TreeNode node = TreeUtil.findNode(tree, object);
                if (node == null) continue;
                node.setAttribute(TEMPORARY_FLAG, new Boolean(true));
            }
        }
        TreeUtil.markAncestor(tree, ids);
        tree = TreeUtil.removeUnmarkedNodes(tree);
        TreeUtil.removeMark(tree);
        return tree;
    }

    private static TreeNode[] getSons(List<TreeNode> nodes, Object parentid) {
        if (nodes == null || nodes.isEmpty()) {
            return new TreeNode[0];
        }
        ArrayList<TreeNode> leftNodes = new ArrayList<TreeNode>();
        for (int i = 0; i < nodes.size(); ++i) {
            TreeNode node = nodes.get(i);
            leftNodes.add(node);
        }
        return TreeUtil.getSons_(leftNodes, parentid);
    }

    private static TreeNode[] getSons_(List<TreeNode> nodes, Object parentid) {
        TreeNode node;
        int i;
        TreeNode[] sons = null;
        if (parentid == null) {
            parentid = "";
        }
        TreeNode[] tns = new TreeNode[nodes.size()];
        tns = nodes.toArray(tns);
        for (i = 0; i < tns.length; ++i) {
            node = tns[i];
            if (!parentid.equals(node.getParentId())) continue;
            if (sons == null) {
                sons = new TreeNode[]{node};
            } else {
                TreeNode[] temp = sons;
                sons = new TreeNode[temp.length + 1];
                for (int j = 0; j < temp.length; ++j) {
                    sons[j] = temp[j];
                }
                sons[temp.length] = node;
                temp = null;
            }
            nodes.remove(node);
        }
        if (sons == null || sons.length == 0) {
            return new TreeNode[0];
        }
        for (i = 0; i < sons.length; ++i) {
            node = sons[i];
            node.addSons(TreeUtil.getSons_(nodes, node.getId()));
        }
        return sons;
    }

    private static void markAncestor(TreeNode tree, Collection<? extends Object> ids) {
        if (tree == null || ids == null || ids.size() == 0) {
            return;
        }
        boolean hasMarkedSon = false;
        if (tree.hasSon()) {
            TreeNode[] sons = tree.getSons();
            for (int i = 0; i < sons.length; ++i) {
                TreeUtil.markAncestor(sons[i], ids);
                Boolean bl = (Boolean)sons[i].getAttribute(TEMPORARY_FLAG);
                hasMarkedSon = hasMarkedSon || bl != null && bl != false;
            }
        }
        if (hasMarkedSon) {
            tree.setAttribute(TEMPORARY_FLAG, new Boolean(true));
        }
    }

    private static void markFamily(Boolean parentMarkFlag, TreeNode tree, Collection<? extends Object> ids) {
        if (tree == null || ids == null || ids.size() == 0) {
            return;
        }
        Object currentId = tree.getId();
        if (parentMarkFlag != null && parentMarkFlag.booleanValue() || ids.contains(currentId)) {
            tree.setAttribute(TEMPORARY_FLAG, new Boolean(true));
        }
        if (tree.hasSon()) {
            TreeNode[] sons = tree.getSons();
            for (int i = 0; i < sons.length; ++i) {
                TreeUtil.markFamily((Boolean)tree.getAttribute(TEMPORARY_FLAG), sons[i], ids);
            }
        }
    }

    public static boolean isMarked(TreeNode node) {
        Boolean bl = (Boolean)node.getAttribute(TEMPORARY_FLAG);
        return bl != null && bl != false;
    }

    private static TreeNode removeUnmarkedNodes(TreeNode tree) {
        if (tree == null) {
            return null;
        }
        if (tree.hasSon()) {
            TreeNode[] sons = tree.getSons();
            for (int i = 0; i < sons.length; ++i) {
                TreeUtil.removeUnmarkedNodes(sons[i]);
                if (!TreeUtil.canDelete(sons[i])) continue;
                tree.removeSon(sons[i]);
            }
        }
        return tree;
    }

    private static boolean canDelete(TreeNode node) {
        boolean bl1 = !node.hasSon();
        Boolean bl = (Boolean)node.getAttribute(TEMPORARY_FLAG);
        boolean bl2 = bl == null || bl == false;
        return bl1 && bl2;
    }

    private static void removeMark(TreeNode tree) {
        if (tree == null) {
            return;
        }
        tree.setAttribute(TEMPORARY_FLAG, null);
        if (tree.hasSon()) {
            TreeNode[] sons = tree.getSons();
            for (int i = 0; i < sons.length; ++i) {
                TreeUtil.removeMark(sons[i]);
            }
        }
    }

    private static void setActiveFlag(TreeNode node, Boolean bl) {
        node.setActiveFlag(bl);
        if (node.hasSon()) {
            TreeNode[] sons = node.getSons();
            for (int i = 0; i < sons.length; ++i) {
                TreeUtil.setActiveFlag(sons[i], bl);
            }
        }
    }

    private static TreeNode[] appendArray(TreeNode[] objs, TreeNode[] toAdd) {
        int i;
        if (toAdd == null) {
            return objs;
        }
        if (objs == null) {
            return toAdd;
        }
        int count1 = objs.length;
        int count2 = toAdd.length;
        TreeNode[] newArray = new TreeNode[count1 + count2];
        for (i = 0; i < count1; ++i) {
            newArray[i] = objs[i];
        }
        for (i = 0; i < count2; ++i) {
            newArray[count1 + i] = toAdd[i];
        }
        return newArray;
    }

    private static void saveSelfAndSonIds(TreeNode tree, Collection<Object> ids) {
        if (tree == null || tree.getId() == null) {
            return;
        }
        Object id = tree.getId();
        if (id instanceof String && ((String)id).trim().length() == 0) {
            id = null;
        }
        if (id != null) {
            ids.add(id);
        }
        TreeNode[] sons = tree.getSons();
        for (int i = 0; sons != null && i < sons.length; ++i) {
            TreeUtil.saveSelfAndSonIds(sons[i], ids);
        }
    }
}

