/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.config.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import org.ehcache.Cache;
import team.bangbang.common.CommonMPI;
import team.bangbang.common.data.CustomizeCache;
import team.bangbang.common.log.Logger;
import team.bangbang.common.net.http.HttpClient;
import team.bangbang.common.net.http.ResponseHandler;
import team.bangbang.config.data.Item;

public final class ItemService {
    private static Logger log = Logger.getInstance(ItemService.class);
    private static Cache<String, Object> cache = CustomizeCache.createCache("ItemService", 300);
    private static HttpClient hc = new HttpClient();

    public static List<Item> getItemList(String category, String parentCode) {
        String cacheKey = "ItemList:" + category + ":" + parentCode;
        if (cache != null && cache.containsKey((Object)cacheKey)) {
            try {
                String s = (String)cache.get((Object)cacheKey);
                return JSONArray.parseArray((String)s).toJavaList(Item.class);
            }
            catch (Exception ex) {
                return null;
            }
        }
        String consoleRoot = CommonMPI.getConsoleRoot();
        if (consoleRoot == null || consoleRoot.length() < 5) {
            return Collections.emptyList();
        }
        if (category == null || category.trim().length() == 0) {
            return Collections.emptyList();
        }
        String service = consoleRoot + "api/config/getItemList";
        try {
            JSONArray arr;
            String data = "category=" + category;
            if (parentCode != null) {
                data = data + "&parentCode=" + parentCode;
            }
            ResponseHandler rh = hc.post(service, data, "application/x-www-form-urlencoded");
            JSONObject json = rh.toJSONObject();
            if (rh.getHttpStatus() != 200) {
                log.log(9993, (Object)("\u8c03\u7528 " + service + " \u51fa\u73b0\u5f02\u5e38\uff1a" + json));
                return null;
            }
            JSONArray jSONArray = arr = json.containsKey((Object)"dto") ? json.getJSONArray("dto") : null;
            if (cache != null && arr != null) {
                cache.put((Object)cacheKey, (Object)(arr != null ? arr.toJSONString() : null));
            }
            return arr != null ? arr.toJavaList(Item.class) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(9993, (Object)("\u8c03\u7528 " + service + " \u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage()));
            return Collections.emptyList();
        }
    }

    public static Item getItem(String category, String itemCode) {
        return ItemService.getItem(category, itemCode, null);
    }

    public static Item getItem(String category, String itemCode, String itemName) {
        if (category == null || category.trim().length() == 0) {
            return null;
        }
        if (!(itemCode != null && itemCode.trim().length() != 0 || itemName != null && itemName.trim().length() != 0)) {
            return null;
        }
        if (itemCode == null) {
            itemCode = "";
        }
        if (itemName == null) {
            itemName = "";
        }
        String cacheKey = "Item:" + category + ":" + itemCode + ":" + itemName;
        if (cache != null && cache.containsKey((Object)cacheKey)) {
            try {
                String s = (String)cache.get((Object)cacheKey);
                return (Item)JSONObject.parseObject((String)s).toJavaObject(Item.class);
            }
            catch (Exception ex) {
                return null;
            }
        }
        String consoleRoot = CommonMPI.getConsoleRoot();
        if (consoleRoot == null || consoleRoot.length() < 5) {
            return null;
        }
        String service = consoleRoot + "api/config/getItem";
        try {
            String data = "category=" + category + "&itemCode=" + itemCode + "&itemName=" + itemName;
            ResponseHandler rh = hc.post(service, data, "application/x-www-form-urlencoded");
            JSONObject json = rh.toJSONObject();
            if (rh.getHttpStatus() != 200) {
                log.log(9993, (Object)("\u8c03\u7528 " + service + " \u51fa\u73b0\u5f02\u5e38\uff1a" + json));
                return null;
            }
            JSONObject jSONObject = json = json.containsKey((Object)"dto") ? json.getJSONObject("dto") : null;
            if (cache != null && json != null) {
                cache.put((Object)cacheKey, (Object)(json != null ? json.toJSONString() : null));
            }
            return json != null ? (Item)json.toJavaObject(Item.class) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(9993, (Object)("\u8c03\u7528 " + service + " \u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage()));
            return null;
        }
    }
}

