/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.config.service;

import com.alibaba.fastjson.JSONObject;
import org.ehcache.Cache;
import team.bangbang.common.CommonMPI;
import team.bangbang.common.data.CustomizeCache;
import team.bangbang.common.log.Logger;
import team.bangbang.common.net.http.HttpClient;
import team.bangbang.common.net.http.ResponseHandler;
import team.bangbang.config.data.Parameter;

public final class ParameterService {
    private static Logger log = Logger.getInstance(ParameterService.class);
    private static Cache<String, Object> cache = CustomizeCache.createCache("ParameterService", 300);
    private static HttpClient hc = new HttpClient();

    public static Parameter getParameter(String module, String parameterName) {
        String cacheKey = "Parameter:" + module + ":" + parameterName;
        if (cache != null && cache.containsKey((Object)cacheKey)) {
            try {
                String s = (String)cache.get((Object)cacheKey);
                return (Parameter)JSONObject.parseObject((String)s).toJavaObject(Parameter.class);
            }
            catch (Exception ex) {
                return null;
            }
        }
        String consoleRoot = CommonMPI.getConsoleRoot();
        if (consoleRoot == null || consoleRoot.length() < 5) {
            return null;
        }
        if (module == null || module.trim().length() == 0 || parameterName == null || parameterName.trim().length() == 0) {
            return null;
        }
        String service = consoleRoot + "api/config/getParameter";
        try {
            ResponseHandler rh = hc.post(service, "module=" + module + "&parameterName=" + parameterName, "application/x-www-form-urlencoded");
            JSONObject json = rh.toJSONObject();
            if (rh.getHttpStatus() != 200) {
                log.log(9993, (Object)("\u8c03\u7528 " + service + " \u51fa\u73b0\u5f02\u5e38\uff1a" + json));
                return null;
            }
            JSONObject jSONObject = json = json.containsKey((Object)"dto") ? json.getJSONObject("dto") : null;
            if (cache != null && json != null) {
                cache.put((Object)cacheKey, (Object)(json != null ? json.toJSONString() : null));
            }
            return json != null ? (Parameter)json.toJavaObject(Parameter.class) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(9993, (Object)("\u8c03\u7528 " + service + " \u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage()));
            return null;
        }
    }
}

