/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import team.bangbang.common.config.Constants;
import team.bangbang.common.file.FileWriter;
import tools.UnicodeReader;

public class BOMRemove {
    private static int nCount = 0;
    private static String[] exts = new String[]{".java"};

    public static void main(String[] args) {
        File f;
        if (args == null || args.length < 1) {
            System.out.println("Usage:" + Constants.LINE_SEPARATOR + " Java -cp <\u5357\u745e\u4fe1\u901a_common.jar> cn.js.tools.BOMRemove [source directory]");
            System.exit(0);
        }
        if (!(f = new File(args[0])).exists()) {
            System.out.println("The source directory speciafied is not exist.");
            System.exit(0);
        }
        BOMRemove.changeEncoding(f);
        System.out.println("Summary: " + nCount + " file(s) processed.");
    }

    private static void changeEncoding(File file) {
        if (file.isDirectory()) {
            File[] sons = file.listFiles();
            for (int i = 0; sons != null && i < sons.length; ++i) {
                BOMRemove.changeEncoding(sons[i]);
            }
            return;
        }
        try {
            if (BOMRemove.isTextFile(file)) {
                BOMRemove.contentTranslate(file);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isTextFile(File f) {
        String fileName = f.getName().toLowerCase();
        for (String str : exts) {
            if (!fileName.endsWith(str)) continue;
            return true;
        }
        return false;
    }

    private static void contentTranslate(File f) throws Exception {
        FileInputStream fis = new FileInputStream(f);
        UnicodeReader reader = new UnicodeReader(fis, "UTF-8");
        BufferedReader br = new BufferedReader(reader);
        StringBuffer sb = new StringBuffer();
        int len = 512;
        char[] buff = new char[len];
        while ((len = br.read(buff)) > 0) {
            sb.append(buff, 0, len);
        }
        fis.close();
        br.close();
        if (sb.length() == 0) {
            System.out.println("Ignore file " + f.getCanonicalPath());
            return;
        }
        FileWriter writer = new FileWriter(f);
        writer.writeString(sb.toString(), "UTF-8");
        System.out.println(f.getCanonicalPath());
        ++nCount;
    }
}

