/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import team.bangbang.common.config.Config;
import team.bangbang.common.sql.SQLPool;
import team.bangbang.common.sql.generator.TableKeyMetaData;
import tools.Field;

public class DBCompare {
    private static final String ALIAS_DEFAULT = "application";
    private static final String ALIAS_OTHER = "other";

    public static void main(String[] args) {
        int i;
        Set<String> tbls1 = TableKeyMetaData.getTables(ALIAS_DEFAULT);
        Set<String> tbls2 = TableKeyMetaData.getTables(ALIAS_OTHER);
        ArrayList<String> joinList = new ArrayList<String>();
        System.out.print("## 1. \u4ee5default\u4e3a\u57fa\u51c6\uff0cother\u7f3a\u5c11\u7684\u8868 ");
        ArrayList<String> noList = new ArrayList<String>();
        for (String table : tbls1) {
            if (!tbls2.contains(table)) {
                noList.add(table);
                continue;
            }
            joinList.add(table);
        }
        System.out.println(noList.size() + " \u5f20");
        Collections.sort(noList);
        for (i = 0; i < noList.size(); ++i) {
            System.out.println("\t" + (i + 1) + "  - " + (String)noList.get(i));
        }
        System.out.println("\n");
        Collections.sort(joinList);
        System.out.println("## 2. \u4ee5default\u4e3a\u57fa\u51c6\uff0cother\u7f3a\u5c11\uff08-\uff09\u3001\u4fee\u6539\uff08*\uff09\u3001\u589e\u52a0\uff08+\uff09\u7684\u5b57\u6bb5");
        for (i = 0; i < joinList.size(); ++i) {
            String s3;
            String s2;
            String table;
            table = (String)joinList.get(i);
            Map<String, Field> mp1 = DBCompare.getFields(ALIAS_DEFAULT, table);
            Map<String, Field> mp2 = DBCompare.getFields(ALIAS_OTHER, table);
            StringBuffer sb = new StringBuffer();
            String s1 = DBCompare.compareFields1(table, mp1, mp2);
            if (s1 != null && s1.trim().length() > 0) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(s1);
            }
            if ((s2 = DBCompare.compareFields2(table, mp1, mp2)) != null && s2.trim().length() > 0) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(s2);
            }
            if ((s3 = DBCompare.compareFields3(table, mp1, mp2)) != null && s3.trim().length() > 0) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(s3);
            }
            if (sb.length() <= 0) continue;
            sb.insert(0, "\t " + table + "\n");
            System.out.println(sb);
            System.out.println();
        }
    }

    private static String compareFields3(String table, Map<String, Field> mp1, Map<String, Field> mp2) {
        StringBuffer sb = new StringBuffer();
        for (String name : mp2.keySet()) {
            Field f1 = mp1.get(name);
            Field f2 = mp2.get(name);
            if (f1 != null) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("\t  + " + f2.name + " " + f2.type + "(" + f2.size + ")");
        }
        return sb.toString();
    }

    private static String compareFields2(String table, Map<String, Field> mp1, Map<String, Field> mp2) {
        StringBuffer sb = new StringBuffer();
        for (String name : mp1.keySet()) {
            Field f1 = mp1.get(name);
            Field f2 = mp2.get(name);
            if (f2 == null || f1.type.equals(f2.type) && f1.size == f2.size) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("\t  * " + f1.name + " " + f1.type + DBCompare.getTypeSize(f1.size) + " ==> " + f2.name + " " + f2.type + DBCompare.getTypeSize(f2.size));
        }
        return sb.toString();
    }

    private static String getTypeSize(int size) {
        return size <= 0 ? "" : "(" + size + ")";
    }

    private static String compareFields1(String table, Map<String, Field> mp1, Map<String, Field> mp2) {
        StringBuffer sb = new StringBuffer();
        for (String name : mp1.keySet()) {
            Field f1 = mp1.get(name);
            Field f2 = mp2.get(name);
            if (f2 != null) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("\t  - " + f1.name);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Field> getFields(String alias, String table) {
        HashMap<String, Field> mp = new HashMap<String, Field>();
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = SQLPool.getConnection(alias);
            String catalog = conn.getCatalog();
            DatabaseMetaData dmd = conn.getMetaData();
            String schema = DBCompare.getSchema(dmd, alias);
            rs = dmd.getColumns(catalog, schema, table, null);
            if (rs != null) {
                while (rs.next()) {
                    Field f = new Field();
                    f.name = rs.getString("COLUMN_NAME");
                    f.type = rs.getString("TYPE_NAME").toLowerCase();
                    if (!f.type.equals("bigint") && !f.type.equals("tinyint") && f.type.indexOf("date") <= 0 && f.type.indexOf("time") <= 0) {
                        f.size = rs.getInt("COLUMN_SIZE");
                    }
                    mp.put(f.name, f);
                }
                rs.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return mp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSchema(DatabaseMetaData dmd, String alias) {
        String schema = Config.getProperty(alias + ".connection.schema");
        if (schema == null) {
            String username = Config.getProperty(alias + ".connection.username");
            ResultSet rs = null;
            try {
                rs = dmd.getSchemas();
                while (rs != null && rs.next()) {
                    String temp = rs.getString(1);
                    if (temp == null || !temp.equalsIgnoreCase(username)) continue;
                    schema = temp;
                    break;
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (schema != null && schema.trim().length() == 0) {
            schema = null;
        }
        return schema;
    }
}

