/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import team.bangbang.common.config.Constants;
import team.bangbang.common.file.FileReader;

public class SourceCombine {
    private static int nCount = 0;
    private static String[] exts = new String[]{".jsp", ".java", ".html", ".htm"};
    private static FileWriter fw = null;

    public static void main(String[] args) throws IOException {
        File tf;
        File p_tf;
        File sf;
        if (args == null || args.length < 2) {
            System.out.println("Usage:" + Constants.LINE_SEPARATOR + " Java team.bangbang.tools.SourceCombine  [source directory] [target file]");
            System.exit(0);
        }
        if (!(sf = new File(args[0])).exists()) {
            System.out.println("The source directory speciafied is not exist.");
            System.exit(0);
        }
        if (!(p_tf = (tf = new File(args[1])).getParentFile()).exists()) {
            p_tf.mkdirs();
        }
        fw = new FileWriter(tf);
        SourceCombine.copyFile(sf);
        fw.close();
        System.out.println("Summary: " + nCount + " file(s) processed.");
    }

    private static void copyFile(File file) {
        if (file.isDirectory()) {
            File[] sons = file.listFiles();
            for (int i = 0; sons != null && i < sons.length; ++i) {
                SourceCombine.copyFile(sons[i]);
            }
            return;
        }
        try {
            if (SourceCombine.isSourceFile(file)) {
                SourceCombine.copySource(file);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isSourceFile(File f) {
        String fileName = f.getName().toLowerCase();
        for (String str : exts) {
            if (!fileName.endsWith(str)) continue;
            return true;
        }
        return false;
    }

    private static void copySource(File f) throws Exception {
        FileReader reader = new FileReader(f);
        String content = reader.readString();
        if (content == null || content.length() == 0) {
            System.out.println("Ignore file " + f.getCanonicalPath());
            return;
        }
        System.out.println(f.getCanonicalPath());
        fw.write(Constants.LINE_SEPARATOR);
        fw.write(Constants.LINE_SEPARATOR);
        fw.write(content);
        fw.write(Constants.LINE_SEPARATOR);
        fw.write(Constants.LINE_SEPARATOR);
        fw.flush();
        ++nCount;
    }
}

