package team.bangbang.common.data;

import java.time.Duration;

import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;

/**
 * 使用JCache进行封装，依赖JCache和EhCache。
 *
 * @author 帮帮组
 * @version 1.0 2018年10月16日
 */
public class CustomizeCache {
	/* 缓存Manager */
	private static CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().build(true);

	private CustomizeCache() {
	}

	/**
	 * 创建一个缓存
	 *
	 * @param cacheName     缓存名称
	 * @param expireSeconds 失效时间，单位：秒
	 * @return 缓存对象
	 */
	public static Cache<String, Object> createCache(String cacheName, int expireSeconds) {
		if(cacheManager == null) return null;

		// 配置
        CacheConfiguration<String, Object> cc = CacheConfigurationBuilder
                .newCacheConfigurationBuilder(String.class, Object.class, ResourcePoolsBuilder.heap(100))
                .withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration(Duration.ofSeconds(expireSeconds))).build();

		return cacheManager.createCache(cacheName, cc);
	}
}
