package team.bangbang.common.data;

//************************************************************************
//系统名称：帮帮WEB开发辅助类库
//class名称：Key-Value对应单体类
/**
* 本类仅供存储Key-Value对应关系，重写了hashCode()、equals()和toString()方法
*
* @author 帮帮组
* @version 1.0
* 
* @version 1.1 添加默认构造方法，同时添加key、value属性的setter方法
*/
//************************************************************************
public final class KeyValue implements java.io.Serializable {
	private static final long serialVersionUID = 6921791867084468226L;
	/* Key值 */
	private Object key = null;
	/* Value值 */
	private Object value = null;

	/**
	 * 默认构造方法
	 */
	public KeyValue() {}

	/**
	 * 构造方法
	 *
	 * @param key Key值
	 * @param value Value值
	 */
	public KeyValue(Object key, Object value) {
		this.key = key;
		this.value = value;
	}

	/**
	 * @param key Key值
	 */
	public void setKey(Object key) {
		this.key = key;
	}

	/**
	 * @param value Value值
	 */
	public void setValue(Object value) {
		this.value = value;
	}

	/**
	 * 获得Key值
	 *
	 * @return Key值
	 */
	public Object getKey() {
		return key;
	}

	/**
	 * 获得Value值
	 *
	 * @return Value值
	 */
	public Object getValue() {
		return value;
	}

	@Override
	public int hashCode() {
		return toString().hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof KeyValue))
			return false;

		KeyValue objKV = (KeyValue) obj;

		return equals(getKey(), objKV.getKey())
				&& equals(getValue(), objKV.getValue());
	}

	/**
	 * 判定两个对象是否相同。如果同为null也视为相同。
	 *
	 * @param obj1 对象一
	 * @param obj2 对象二
	 * @return true: 两个对象相同
	 *         false: 两个对象不同
	 */
	private boolean equals(Object obj1, Object obj2) {
		if (obj1 == null) {
			return (obj2 == null);
		} else {
			return obj1.equals(obj2);
		}
	}

	/**
	 * (non-Javadoc)
	 * @see Object#toString()
	 * @return 个体描述
	 */
	public String toString() {
		return "key = " + getKey() + "\n" +
			"value = " + getValue() + "\n";
	}
}
