package team.bangbang.common.data;

import team.bangbang.common.config.Constants;
import team.bangbang.common.data.DataSort;

//************************************************************************
//系统名称：帮帮WEB开发辅助类库
//class名称：分页配置
/**
* 1. 用于保存页面请求的分页参数，后将页面分页参数传递给数据库Helper对象（如SQLHelper、MongoHelper）；
*    然后保存分页结果数据，后将分页结果数据传递到JSP页面
*
* 2. 传递排序的字段名称和排序顺序
*
* @author 帮帮组
* @version 1.0
*/
//************************************************************************
public class Pagination implements java.io.Serializable {
	private static final long serialVersionUID = -6017541488933958773L;
	/* 当前页号 */
	private int nPageNo = 1;
	/* 总记录数 */
	private int nRecordCount = 0;
	/* 每一页的最大记录条数 */
	private int pageSize = 0;
	/* 排序字段及排序方向数据 */
	private DataSort dataSort = new DataSort();

	/**
	 * 设置每一页的最大记录条数
	 *
	 * @param pageSize 每一页的最大记录条数
	 */
	public void setMaxResults(int pageSize) {
		this.pageSize = pageSize;
	}

	/**
	 * 获得分页的总页数
	 *
	 * @return 分页的总页数，从1开始
	 */
	public int getPageCount() {
		int nPageCount = getRecordCount() / getMaxResults();
		if (getRecordCount() % getMaxResults() > 0)
			nPageCount++;

		if(nPageCount == 0) nPageCount = 1;
		return nPageCount;
	}


	/**
	 * 得到当前页需要的记录在数据库中的起始位置
	 *
	 * @return 当前页需要的记录在数据库中的起始位置，从0开始
	 */
	public int getStartPosition() {
		return (getPageNo() - 1) * getMaxResults();
	}

	/**
	 * 获得每一页可以显示的最大记录条数，如果没有调用setMaxResults(int)方法设置该参数，
	 * 则默认值为team.bangbang.common.Constants.PAGESIZE。
	 *
	 * @return 每一页可以显示的最多记录条数
	 */
	public int getMaxResults() {
		return (pageSize > 0) ? pageSize: Constants.PAGE_SIZE;
	}

	/**
	 * 获得当前页号
	 *
	 * @return 当前页号，从1开始
	 */
	public int getPageNo() {
		if(nPageNo < 1) return nPageNo = 1;
		if(nPageNo > getPageCount()) nPageNo = getPageCount();
		return nPageNo;
	}

	/**
	 * 设置当前页号
	 *
	 * @param pageNo 当前页号
	 */
	public void setPageNo(int pageNo) {
		nPageNo = pageNo;
	}

	/**
	 * 获得总记录数
	 *
	 * @return 总记录数
	 */
	public int getRecordCount() {
		return nRecordCount;
	}

	/**
	 * 设置总记录数
	 *
	 * @param recordCount 总记录数
	 */
	public void setRecordCount(int recordCount) {
		nRecordCount = recordCount;
	}

	/**
	 * @return 排序字段及排序方向数据
	 */
	public DataSort getDataSort() {
		return dataSort;
	}

	/**
	 * @param dataSort 排序字段及排序方向数据
	 */
	public void setDataSort(DataSort dataSort) {
		this.dataSort = dataSort;
	}
}
