package team.bangbang.common.data;

/**
 * 状态码，200、404参照HTTP状态码，其它与HTTP状态码不同
 *
 * @author 帮帮组
 * @version 1.0 2020-12-10
 */
public final class StatusCode {
	/** 成功 */
	public static final int SUCCESS = 200;

	/** 40X段请求问题 - 无权限 */
	public static final int REQUEST_PERMISSION_DENIED= 401;
	/** 40X段请求问题 - 请求次数超限，暂时封禁 */
	public static final int REQUEST_OUT_LIMIT = 402;
	/** 40X段请求问题 - 缺少请求数据 */
	public static final int REQUEST_DATA_EXPECTED = 403;
	/** 40X段请求问题 - 请求的服务不存在 */
	public static final int REQUEST_URI_NOT_FOUND = 404;
	/** 40X段请求问题 - 请求的数据格式有误 */
	public static final int REQUEST_DATA_FORMAT_INVALID = 405;

	/** 60X段授权问题 - 认证Token票据无效 */
	public static final int AUTHENTICATION_TOKEN_INVALID = 601;
	/** 60X段授权问题 - 未发现身份认证信息 */
	public static final int AUTHENTICATION_IDENTITY_MISS = 602;
	/** 60X段授权问题 - 认证签名sign无效 */
	public static final int AUTHENTICATION_SIGN_INVALID = 603;
	/** 60X段授权问题 - 请求IP不被允许 */
	public static final int AUTHENTICATION_IP_INVALID = 604;	
    
	/** 70X段数据问题 - 重复的记录 */
	public static final int DATA_DUPLICATE = 701;
	/** 70X段数据问题 - 数据受保护，不可修改或删除 */
	public static final int DATA_PROTECTED = 702;
	/** 70X段数据问题 - 数据未发现 */
	public static final int DATA_NOT_FOUND = 703;
	/** 70X段数据问题 - 数据不匹配 */
	public static final int DATA_NOT_MATCH = 704;
	/** 30X段权限 - 数据状态错误 */
	public static final int DATA_STATUS_ERROR = 705;

	/** 80X段异常 - 异常发生 */
	public static final int EXCEPTION_OCCURED = 801;
}
