package team.bangbang.common.data;

import java.util.HashMap;
import java.util.Map;

//************************************************************************
//系统名称：帮帮WEB开发辅助类库
//class名称：线程变量
/**
 * 用于保存线程变量
 *
 * @author 帮帮组
 * @version 1.0
 */
// ************************************************************************
public final class ThreadVariable {
	/* 线程变量对象 */
	private static ThreadLocal<Map<String, Object>> tl = new ThreadLocal<Map<String, Object>>();

	/**
	 * @param key
	 *            变量Key值
	 *
	 * @return 变量value值
	 */
	public static Object getVariable(String key) {
		Map<String, Object> mp = tl.get();
		if (mp == null) {
			return null;
		}

		return mp.get(key);
	}

	/**
	 * 将数据保存到线程变量中
	 *
	 * @param key
	 *            Key值
	 * @param value
	 *            保存的数据
	 */
	public static void setVariable(String key, Object value) {
		Map<String, Object> mp = tl.get();
		if (mp == null) {
			mp = new HashMap<String, Object>();
			tl.set(mp);
		}

		mp.put(key, value);
	}
	
	/**
	 * 删除线程变量
	 * 
	 * @param key 变量Key值
	 */
	public static void removeVariable(String key) {
		Map<String, Object> mp = tl.get();
		if (mp == null || !mp.containsKey(key)) {
			return;
		}

		mp.remove(key);
	}
	
	/**
	 * 删除所有原有的线程变量。
	 * 
	 * 如果在一个线程中需要使用线程变量，则最好在请求开始阶段删除所有原有的线程变量
	 */
	public static void removeAll() {
		Map<String, Object> mp = tl.get();
		if (mp == null) {
			return;
		}

		mp.clear();
	}
}
