package team.bangbang.common.data;

import team.bangbang.common.CommonMPI;

/**
 * 验证码，包括一个验证码字符串、验证码生成的时间
 *
 * @author 帮帮组
 * @version 1.0 2012-6-24
 */
public class ValidationCode {
	private static ValidationCode vc = new ValidationCode();

	/**
	 * 生成验证码，可以包含数字和字母，默认输出纯数字
	 *
	 * @param length
	 *            验证码文字长度
	 *
	 * @return 验证码，可以包含数字和字母
	 */
	public static CodeEntity getCodeEntity(int length) {
		return getCodeEntity(length, true);
	}

	/**
	 * 生成验证码，可以限定验证码是否为纯数字
	 *
	 * @param length
	 *            验证码文字长度
	 * @param onlyNumber
	 *            是否全部为数字
	 *
	 * @return 验证码
	 */
	public static CodeEntity getCodeEntity(int length, boolean onlyNumber) {
		CodeEntity ce = vc.new CodeEntity();
		if (onlyNumber) {
			ce.letter = CommonMPI.getRandomNumber(length);
		} else {
			ce.letter = CommonMPI.getRandomString(length);
		}
		ce.time = System.currentTimeMillis();

		return ce;
	}

	/**
	 * 验证码，包括一个验证码文字、验证码创建时间
	 *
	 * @author 帮帮组
	 * @version 1.0 2012-6-24
	 */
	public class CodeEntity {
		/** 验证码文字 */
		public String letter = null;
		/** 验证码创建时间 */
		public long time = 0L;
	}
}
