package team.bangbang.common.data.response;

import com.alibaba.fastjson.JSONObject;

/**
 * HTTP接口响应，携带单个实体结果
 *
 * @author Bangbang
 * @version 1.0 2020年8月8日
 *
 * @param <T> 携带数据实体类型
 */
public class DataResponse<T> extends ResponseBase {
	/* 响应数据实体 */
	private T data = null;

	/**
	 * 构造方法1
	 */
	public DataResponse() {
		super();
	}

	/**
	 * 构造方法3
	 * @param code 状态码
	 * @param message 结果消息
	 */
	public DataResponse(int code, String message) {
		super(code, message);
	}

	/**
	 * @return 响应数据实体
	 */
	public T getData() {
		return data;
	}

	/**
	 * @param data 响应数据实体
	 */
	public void setData(T data) {
		this.data = data;
	}

    /**
     * @return 转变为JSON字符串
     */
	public String toString() {
    	return JSONObject.toJSONString(this);
	}
}
