package team.bangbang.common.data.response;

import com.alibaba.fastjson.JSONObject;

import team.bangbang.common.data.StatusCode;

/**
 * HTTP接口响应数据
 *
 *
 * @author 帮帮组
 * @version 1.0 2017年9月6日
 */
public class ResponseBase {
	/** 成功 */
	public static final ResponseBase SUCCESS = new ResponseBase(StatusCode.SUCCESS, "成功");
	/** 无权限 */
	public static final ResponseBase REQUEST_PERMISSION_DENIED = new ResponseBase(StatusCode.REQUEST_PERMISSION_DENIED, "无权限");
	/** 请求次数超限，暂时封禁 */
	public static final ResponseBase REQUEST_OUT_LIMIT = new ResponseBase(StatusCode.REQUEST_OUT_LIMIT, "请求次数超限，暂时封禁");
	/** 缺少请求数据 */
	public static final ResponseBase REQUEST_DATA_EXPECTED = new ResponseBase(StatusCode.REQUEST_DATA_EXPECTED, "缺少请求数据");
	/** 请求的服务不存在 */
	public static final ResponseBase REQUEST_URI_NOT_FOUND = new ResponseBase(StatusCode.REQUEST_URI_NOT_FOUND, "请求的服务不存在");
	/** 请求的数据格式有误 */
	public static final ResponseBase REQUEST_DATA_FORMAT_INVALID = new ResponseBase(StatusCode.REQUEST_DATA_FORMAT_INVALID, "请求的数据格式有误");

	/** 认证Token票据无效 */
	public static final ResponseBase AUTHENTICATION_TOKEN_INVALID = new ResponseBase(StatusCode.AUTHENTICATION_TOKEN_INVALID, "AUTHENTICATION_TOKEN_INVALID");
	/** 未发现身份认证信息 */
	public static final ResponseBase AUTHENTICATION_IDENTITY_MISS = new ResponseBase(StatusCode.AUTHENTICATION_IDENTITY_MISS, "未发现身份认证信息");
	/** 认证签名sign无效 */
	public static final ResponseBase AUTHENTICATION_SIGN_INVALID = new ResponseBase(StatusCode.AUTHENTICATION_SIGN_INVALID, "认证签名sign无效");
	/** 请求IP不被允许 */
	public static final ResponseBase AUTHENTICATION_IP_INVALID = new ResponseBase(StatusCode.AUTHENTICATION_IP_INVALID, "请求IP不被允许");
    
	/** 重复的记录 */
	public static final ResponseBase DATA_DUPLICATE = new ResponseBase(StatusCode.DATA_DUPLICATE, "重复的记录");
	/** 数据受保护，不可修改或删除 */
	public static final ResponseBase DATA_PROTECTED = new ResponseBase(StatusCode.DATA_PROTECTED, "DATA_NOT_FOUND");
	/** 数据未发现 */
	public static final ResponseBase DATA_NOT_FOUND = new ResponseBase(StatusCode.DATA_NOT_FOUND, "数据未发现");
	/** 数据不匹配 */
	public static final ResponseBase DATA_NOT_MATCH = new ResponseBase(StatusCode.DATA_NOT_MATCH, "数据不匹配");
	/** 数据状态错误 */
	public static final ResponseBase DATA_STATUS_ERROR = new ResponseBase(StatusCode.DATA_STATUS_ERROR, "数据状态错误");

	/** 异常发生 */
	public static final ResponseBase EXCEPTION_OCCURED = new ResponseBase(StatusCode.EXCEPTION_OCCURED, "异常发生");
	
    /* 状态码 */
    private int statusCode = 0;
    /* 消息 */
    private String message = null;

	/**
	 * 默认构造方法
	 */
	public ResponseBase() {
		this(StatusCode.SUCCESS, "成功");
	}

	/**
	 * 构造方法3
	 * 
	 * @param statusCode 状态码
	 * @param message 结果消息
	 */
	public ResponseBase(int statusCode, String message) {
		this.statusCode = statusCode;
        this.message = message;
	}

	/**
	 * 构造方法4
	 * 
	 * 设置响应状态码、消息
	 *
	 * @param responseBase 响应信息
	 *
	 * @return 响应信息
	 */
	public ResponseBase set(ResponseBase responseBase) {
		setStatusCode(responseBase.statusCode);
		setMessage(responseBase.message);

		return this;
	}

    /**
     * @return 状态码
     */
    public int getStatusCode() {
        return statusCode;
    }

    /**
     * @param statusCode 状态码
     */
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    /**
     * @return 消息
     */
    public String getMessage() {
        return message;
    }

    /**
     * @param message 消息
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * @return 转变为JSON字符串
     */
	public String toString() {
    	return JSONObject.toJSONString(this);
	}
}
