package team.bangbang.common.data.util;

import java.util.Map;
import java.util.Set;

/**
 * 从Map对象中提取数据转化到指定的类型对象中
 *
 * @author 帮帮组
 * @version 1.0 2017-08-12
 */
public class MapToObject {
    /**
     * 从Map对象中提取数据转化到指定数据类型的对象中
     *
     * @param mp Map对象
     * @param <T>  结果对象的类
     * @param cls 结果数据类型
     * 
     * @return 指定数据类型的对象
     */
    public static <T> T extract(Map<String, Object> mp, Class<T> cls) {
        if(mp == null || mp.isEmpty()) {
            return null;
        }

        // 新建一个对象
        T t = null;
        try {
            t = cls.newInstance();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if(t == null) {
            return null;
        }

        try {
			writeFields(mp, t);
		} catch (Exception e) {
			e.printStackTrace();
		}

        return t;
    }

    /**
     * 从Map对象中提取数据转化到指定数据对象中
     *
     * @param mp Map对象
     * @param <T>  结果数据对象的类
     * @param t 结果数据对象
     * 
     * @throws Exception 异常
     */
    private static <T> void writeFields(Map<String, Object> mp, T t) throws Exception {
        Set<String> keys = mp.keySet();

        for(String key : keys) {
            Object obj = mp.get(key);
            if(obj == null) {
                continue;
            }

            DataShaper.executeExpression(t, key, obj);
        }
    }
}
