package team.bangbang.common.data.util;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/**
 * 指定对象提取属性数据转化到Map对象中，只提取第一层的属性数据
 *
 * @author 帮帮组
 * @version 1.0 2017/8/12
 */
public class ObjectToMap {
    /**
     * 从指定对象提取属性数据转化到Map对象中
     *
     * @param obj Map对象
     * @return 指定数据类型的对象
     */
    public static Map<String, Object> extract(Object obj) {
        if(obj == null) {
            return null;
        }

        // 新建一个Map对象
        Map<String, Object> mp = new HashMap<String, Object>();
        // 源数据的属性
        Class<?> cls = obj.getClass();
        try {
            Method[] ms = cls.getMethods();
            // 取属性名称和值
            for(Method m : ms) {
                // 有参数的过滤掉
                Type[] types = m.getGenericParameterTypes();
                if(types != null && types.length > 0) continue;

                // 非get方法过滤掉
                String name = m.getName();
                if(!name.startsWith("get") || name.equals("getClass")) continue;

                // 首字母小写
                name = name.substring(3, 4).toLowerCase() + name.substring(4);

                Object value = m.invoke(obj);

                if(value != null) mp.put(name, value);
            }
        } catch (Exception e) {
        }

        return mp;
    }
}
