package team.bangbang.common.exception;

import team.bangbang.common.data.StatusCode;

//************************************************************************
//系统名称：帮帮WEB开发辅助类库
//class名称：帮帮例外
/**
 * 作为应用级别的例外实例，即－使用本类库开发应用系统时，受控的所有Exception都应该是本类实例<br>
 * 在程序中，用于向页面反馈提示信息<br>
 * 使用该Exception，错误信息一律传递到/common/message.jsp页面；<br>
 * 其他类型的Exception不能被传递到/common/message.jsp，而被传递到Web Server
 *
 * @author 帮帮组
 * @version 1.0
 */
// ************************************************************************
public class BizException extends Exception {
	private static final long serialVersionUID = 5715360590763714896L;
	/* 状态码 */
	private int statusCode = StatusCode.EXCEPTION_OCCURED;

	/**
	 * @param ex 例外
	 */
	public BizException(Exception ex) {
		super(ex);
	}

	/**
	 * @param message 例外信息
	 */
	public BizException(String message) {
		super(message);
	}

	/**
	 * @param cause Throwable对象
	 */
	public BizException(Throwable cause) {
		super(cause);
	}

	/**
	 * @param statusCode 状态码
	 */
	public void setStatusCode(int statusCode) {
		this.statusCode = statusCode;
	}

	/**
	 * @return 状态码
	 */
	public int getStatusCode() {
		return statusCode;
	}

	/**
	 * @param message 例外信息
	 * @param cause Throwable对象
	 */
	public BizException(String message, Throwable cause) {
		super(message, cause);
	}
}
