package team.bangbang.common.exp;

import java.util.HashSet;
import java.util.Set;

import team.bangbang.common.exception.BizException;


/**
 * 文件导出超类
 *
 * @author 帮帮组
 * @version 1.0  2019-08-17
 */
public abstract class Exporter {
	/* 导出的标题 */
	protected String[] titles = null;
	/* 标题对应的字段 */
	protected String[] fields = null;
	/* 选中的字段集合 */
	protected Set<String> selectedFields = new HashSet<String>();

	/**
	 * @return  导出的标题
	 */
	public String[] getTitles() {
		return titles;
	}

	/**
	 * @param titles  导出的标题
	 */
	public void setTitles(String[] titles) {
		this.titles = titles;
	}

	/**
	 * @return 标题对应的字段
	 */
	public String[] getFields() {
		return fields;
	}

	/**
	 * @param fields 标题对应的字段
	 */
	public void setFields(String[] fields) {
		this.fields = fields;
	}

	/**
	 * @param selects 选中的字段
	 */
	public void setSelectedFields(String[] selects) {
		if(selects == null || selects.length == 0) {
			return;
		}
		selectedFields.clear();

		for(String s : selects) {
			if(s == null || s.trim().length() == 0) continue;
			selectedFields.add(s);
		}
	}

	/**
	 * 导出数据到文件中，此步骤执行完成后，可以使用/download?Temp/{UserId}.dat下载导出的文件。
	 *
	 * @return 下载到客户端的文件信息。
	 * 		String[0]：文件地址，{file.attachment.directory}/Temp/{UserId}.dat <br>
	 * 		String[1]：文件名称
	 * @throws BizException 逻辑异常
	 */
	public abstract String[] export() throws BizException;
}
