package team.bangbang.common.exp;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.URLEncoder;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 文件下载
 *
 * @author Bangbang
 * @version 1.0 2020年12月17日
 */
public final class FileDownloader {

	/**
	 * 将本地的文件使用指定的文件名称下载到浏览器端
	 * 
	 * @param filePath 本地的文件路径
	 * @param fileName 指定的文件名称，如果为空则沿用本地文件名称
	 * @param request  HTTP请求对象
	 * @param response HTTP响应对象
	 * 
	 * @return 下载是否成功
	 */
	public static boolean download(String filePath, String fileName, HttpServletRequest request,
			HttpServletResponse response) {
		// 参数校验
		if (filePath == null || filePath.trim().length() == 0) {
			return false;
		}
		
		if (fileName == null || fileName.trim().length() == 0) {
			// 如果为空则沿用本地文件名称
			fileName = getFileName(filePath);
		} else {
			// 将路径去掉，只保留文件名称
			fileName = getFileName(fileName);
		}

		// 获得客户端浏览器信息
		String agent = request.getHeader("User-Agent");

		FileInputStream fis = null;
		OutputStream sos = null;
		File file = null;
		try {
			response.setContentType("application/octet-stream");
			// response.setHeader("name", strName);

			if (agent != null && agent.indexOf("MSIE ") > 0) {
				fileName = URLEncoder.encode(fileName, "UTF-8");
			} else {
				fileName = new String(fileName.getBytes("UTF-8"), "iso8859-1");
			}
			response.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
			byte buff[] = new byte[512];
			int nLen = 0;

			file = new File(filePath);
			response.setContentLength((int) file.length());
			fis = new FileInputStream(file);
			sos = response.getOutputStream();
			sos.flush();
			while ((nLen = fis.read(buff)) > 0)
				sos.write(buff, 0, nLen);
			sos.flush();
			sos.close();
		} catch (Exception ex) {
			return false;
		} finally {
			try {
				fis.close();
			} catch (Exception exception1) {
			}
			try {
				sos.close();
			} catch (Exception exception2) {
			}
			file = null;
		}

		return true;
	}

	/**
	 * @param filePath
	 *            文件路径，含文件名
	 * @return 文件名
	 */
	private static String getFileName(String filePath) {
		if (filePath == null) {
			return filePath;
		}

		int nIndex = filePath.lastIndexOf("/");
		if (nIndex < 0) {
			nIndex = filePath.lastIndexOf("\\");
		}

		if (nIndex < 0) {
			return filePath;
		}

		return filePath.substring(nIndex + 1);
	}
}
