package team.bangbang.common.exp;

import java.awt.Dimension;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import team.bangbang.common.CommonMPI;
import team.bangbang.common.data.RecordData;
import team.bangbang.common.exception.BizException;
import team.bangbang.common.file.ExcelWriter;
import team.bangbang.common.sql.SQLHelper;

/**
 * SQL语句导出器
 *
 * @author 帮帮组
 * @version 1.0 2016年4月4日
 */
public class SqlExporter extends Exporter {
	/* 操作人编号 */
	private Object accountId = null;
	/* 查询语句 */
	private String sql = null;
	/* 导出的Excel文件名称，不需要带扩展名 */
	private String excelFileName = null;

	/**
	 * @param accountId
	 *            操作人编号
	 * @param sql
	 *            导出数据使用的SQL语句
	 * @param excelFileName
	 *            导出的Excel文件名称，不需要带扩展名
	 */
	public SqlExporter(Object accountId, String sql, String excelFileName) {
		this.accountId = accountId;
		this.sql = sql;
		this.excelFileName = excelFileName;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see team.bangbang.common.exp.IExporter#export()
	 */
	@Override
	public String[] export() throws BizException {
		if (sql == null || titles == null || fields == null) {
			throw new BizException("请首先执行查询，然后再执行导出！");
		}

		ExcelWriter ew = null;
		// 数据库操作
		SQLHelper helper = null;
		RecordData rd = new RecordData();
		try {
			helper = new SQLHelper();
			// 查询
			helper.queryMultipleData(sql, rd, false);

			// 临时文件
			String tempFile = CommonMPI.getAccountTemporaryFile(accountId);
			ew = new ExcelWriter(tempFile);

			// data
			// 行数量
			int count = 0;
			while (rd.next()) {
				if (count % 60000 == 0) {
					int nIndex = (count / 60000);
					// 创建工作簿
					ew.createSheet("数据 " + (nIndex + 1));
					// 从第2行第2列开始写
					ew.toRow(1);
					ew.toColumn(1);
					// 记录位置1
					Dimension off1 = ew.getOffset();
					for (int i = 0; i < titles.length; i++) {
						if (!selectedFields.contains(fields[i])) {
							// 忽略
							continue;
						}

						ew.writeCell(titles[i]);
					}

					// 记录位置2
					Dimension off2 = ew.getOffset();
					// 设置表头样式
					ew.setHeader(off1, off2);
				}

				// 换行
				ew.nextRow();
				// 第2列开始
				ew.toColumn(1);

				for (int i = 0; i < fields.length; i++) {
					if (!selectedFields.contains(fields[i])) {
						// 忽略
						continue;
					}

					Object s = (fields[i] == null || fields[i].trim().length() == 0) ? null : rd.getMultipleData(fields[i]);

					ew.writeCell(s);
				}

				count++;
			}
		} catch (Exception e) {
			throw new BizException(e);
		} finally {
			try {
				if (helper != null)
					helper.close();
			} catch (Exception ex) {
			}
			try {
				if (ew != null)
					ew.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		} // end try

		// 下载到客户端的文件信息。
		// String[0]：文件地址，{file.attachment.directory}/Temp/{UserId}.dat <br>
		// String[1]：文件名称，文件名称进行URL转码
		String s = excelFileName + ".xls";
		try {
			s = URLEncoder.encode(s, "UTF-8");
			s = URLEncoder.encode(s, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		String[] result = {"Temp/" + accountId + ".dat", s};
		return result;
	}
}
