package team.bangbang.common.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URLConnection;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.ObjectMetadata;

import team.bangbang.common.config.Config;

/**
 * 阿里云文件上传、下载器
 *
 * @author 帮帮组
 * @version 1.0 2018年10月23日
 */
public class AliyunOssManager implements IFileManager {
	private static String bucketName = Config.getProperty("file.attachment.manager.aliyun.oss.bucketName");
	private static String accessKeyId = Config.getProperty("file.attachment.manager.aliyun.oss.accessKeyId");
	private static String accessKeySecret = Config.getProperty("file.attachment.manager.aliyun.oss.accessKeySecret");
	private static String endpoint = Config.getProperty("file.attachment.manager.aliyun.oss.endpoint");
	/* 上传后文件地址前缀 */
	private static String aliyunRoot = Config.getProperty("file.attachment.manager.aliyun.root");
	/* OSSClient实例 */
	private static OSS ossClient = null;

	static {
		try {
			ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

			if (ossClient.doesBucketExist(bucketName)) {
				// logger.info("已经创建Bucket：" + bucketName);
			} else {
				// 创建CreateBucketRequest对象。
				CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
				// logger.info("Bucket不存在，创建Bucket：" + bucketName);
				ossClient.createBucket(createBucketRequest);
			}

			// 保证aliyunRoot以/结尾
			if (aliyunRoot == null) {
				aliyunRoot = "";
			}

			aliyunRoot = aliyunRoot.replace('\\', '/');
			if (!aliyunRoot.endsWith("/")) {
				aliyunRoot += "/";
			}
		} catch (Exception ex) {
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see team.bangbang.common.file.IFileManager#put(java.lang.String,
	 * java.lang.String)
	 */
	@Override
	public String put(String localFile, String destSliceFile) throws IOException {
		File lf = new File(localFile);

		String contentType =getMimeType(destSliceFile);

		// 创建上传Object的Metadata
		ObjectMetadata meta = new ObjectMetadata();
		meta.setContentLength(lf.length());
		meta.setContentType(contentType);

		// 上传文件
		ossClient.putObject(bucketName, destSliceFile, lf, meta);
		// System.out.println(result.getETag());

		return (aliyunRoot + destSliceFile).replace('\\', '/');
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see team.bangbang.common.file.IFileManager#exist(java.lang.String)
	 */
	@Override
	public boolean exist(String destSliceFile) throws IOException {
		try {
			return ossClient.doesObjectExist(bucketName, destSliceFile);
		} catch (Exception ex) {
			return false;
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see team.bangbang.common.file.IFileManager#get(java.lang.String)
	 */
	@Override
	public InputStream get(String destFile) throws IOException {
		return null;
	}

	/**
	 * 获得网络文件的MIME类型
	 * 
	 * @param fileUrl 文件URL地址
	 * @return 网络文件的MIME类型
	 * @throws IOException 异常信息
	 */
	private static String getMimeType(String fileUrl) throws IOException {
		FileNameMap fileNameMap = URLConnection.getFileNameMap();
		String type = fileNameMap.getContentTypeFor(fileUrl);
		return type;
	}
}
