package team.bangbang.common.file;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.apache.poi.ss.usermodel.CellType;

/**
 * Excel列信息
 *
 * @author Bangbang
 * @version 1.0  2020年12月12日
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ExcelColumn {
	/**
	 * @return 列编号（从0开始）
	 */
	int index() default 0;
	/**
	 * @return 数据类型
	 */
	CellType type() default CellType.BLANK;
	/**
	 * @return 数值类型字段的取值范围最小值
	 */
	int min() default Integer.MIN_VALUE;
	/**
	 * @return 数值类型字段的取值范围最大值
	 */
	int max() default Integer.MAX_VALUE;
	/**
	 * @return 是否必填
	 */
	boolean required() default false;
}
