package team.bangbang.common.file;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

//************************************************************************
//系统名称：帮帮WEB开发辅助类库
//class名称：Excel读取
/**
 * 使用Java Excel API读取Excel文档信息
 *
 * @author 帮帮组
 * @version 1.0  2012-05-06
 * 已经废弃，推荐使用alibaba的easyexcel。  2021-04-06
 */
// ************************************************************************
@Deprecated
public class ExcelReader {
	/* 数据输入流 */
	private InputStream is = null;
	/* Excel表 */
	private Workbook workbook = null;
	/* 工作表 */
	private Sheet sheet = null;
	/* 行号 */
	private int rowNo = 0;
	/* 当前行 */
	private Row currentRow = null;
	/* 列号 */
	private int columnNo = 0;
	/* 总行数 */
	private int rowCount = 0;

	/**
	 * 构造一个Excel读取对象。
	 *
	 * @param excelFile
	 *            Excel文件，可以是http://或者https://地址
	 *
	 * @throws IOException IO异常
	 */
	public ExcelReader(String excelFile) throws IOException {
		if(excelFile.toLowerCase().startsWith("http://") || excelFile.toLowerCase().startsWith("https://")) {
			URL url = new URL(excelFile);
			this.is = url.openStream();
			this.workbook = new HSSFWorkbook();
			
			if (excelFile.trim().toLowerCase().endsWith(".xlsx")) {
				this.workbook = new XSSFWorkbook(this.is);
			} else {
				this.workbook = new HSSFWorkbook(this.is);
			}
			
		} else {
			this.is = new FileInputStream(excelFile);
			
			if (excelFile.trim().toLowerCase().endsWith(".xlsx")) {
				this.workbook = new XSSFWorkbook(this.is);
			} else {
				this.workbook = new HSSFWorkbook(this.is);
			}
		}
	}

	/**
	 * 使用输入流构造一个Excel读取对象。
	 *
	 * @param is Excel文件输入流
	 *
	 * @throws IOException IO异常
	 */
	public ExcelReader(InputStream is) throws IOException {
		this.is = is;
		this.workbook =  new HSSFWorkbook(is);
	}

	/**
	 * 设置工作表序号
	 *
	 * @param nIndex
	 *            工作表序号based zero
	 */
	public void setSheetIndex(int nIndex) {
		this.sheet = workbook.getSheetAt(nIndex);

		// 行号、列号归零
		rowNo = 0;
		columnNo = 0;
		// 总行数
		rowCount = sheet.getLastRowNum() + 1;
		currentRow = sheet.getRow(rowNo);
	}

	/**
	 * 游标转移到下一行
	 *
	 * @return 是否有下一行
	 */
	public boolean nextRow() {
		// 行号加1
		rowNo++;
		// 列号归零
		columnNo = 0;

		// 已经到最后一行
		boolean hasRow =  (rowNo < rowCount);
		if (hasRow) {
			currentRow = sheet.getRow(rowNo);
		}
		
		return hasRow;
	}

	/**
	 * 跳到指定的行
	 * @param nRow 指定的行
	 * 
	 * @return 是否成功
	 */
	public boolean toRow(int nRow) {
		rowNo = nRow;
		// 列号归零
		columnNo = 0;

		// 已经到最后一行
		boolean hasRow =  (rowNo < rowCount);
		if (hasRow) {
			currentRow = sheet.getRow(rowNo);
		}
		
		return hasRow;
	}

	/**
	 * 跳到指定的列
	 * @param nColumn 指定的列
	 */
	public void toColumn(int nColumn) {
		columnNo = nColumn;
	}

	/**
	 * 得到当前单元格的文本内容
	 *
	 * @return 指定当前单元格的文本内容
	 */
	public Object readCell() {
		if(sheet == null || currentRow == null) return null;

		// 在行、列范围外的，返回 null
		// 已经超出最后一列或者最后一行
		if(rowNo >= rowCount) {
			return null;
		}
		
		// 列数量
		short columnCount = currentRow.getLastCellNum();		
		if (columnNo > columnCount) {
			return null;
		}
		
		// 在行、列范围内的，如果Cell内无内容，返回空字符串“”
		Cell c = currentRow.getCell(columnNo++);
		Object obj = readCell(c);
		return (obj != null ? obj : "");
	}

	/**
	 * 从指定的单元格读取数据
	 * 
	 * @param c 单元格
	 * @return 单元格数据
	 */
	private Object readCell(Cell c) {
		if (c == null) {
			return null;
		}
		// 单元格类型
		CellType ct = c.getCellTypeEnum();
		if (ct == CellType.BLANK) {
			return "";
		}
		if (ct == CellType.BOOLEAN) {
			return c.getBooleanCellValue();
		}		
		if (ct == CellType.ERROR) {
			return "";
		}		
		if (ct == CellType.FORMULA) {
			return c.getCellFormula();
		}
		if (ct == CellType.NUMERIC) {
			return c.getNumericCellValue();
		}
		if (ct == CellType.STRING) {
			return c.getStringCellValue();
		}
		
		return null;
	}

	/**
	 * 得到指定单元格的文本内容
	 *
	 * @param column 列号，以0开始
	 * @param row 行号，以0开始
	 *
	 * @return 指定单元格的文本内容
	 */
	public String readCell(int column, int row) {
		if(sheet == null) return null;

		// 已经超出最后一行？
		if(row >= rowCount) {
			return null;
		}

		// 已经到最后一行
		boolean hasRow =  (rowNo <= rowCount);
		if (hasRow) {
			currentRow = sheet.getRow(rowNo);
		}
		// 已经超出最后一列或者最后一行
		short columnCount = currentRow.getLastCellNum();		
		if(column >= columnCount) {
			return null;
		}

		return currentRow.getCell(column).getStringCellValue();
	}

	/**
	 * 获得当前工作簿的数据行数量
	 *
	 * @return 当前工作簿的数据行数量。如果没有指定当前工作簿，则返回-1
	 */
	public int getRowCount() {
		if(sheet == null) return -1;

		return rowCount;
	}

	/**
	 * 关闭工作簿
	 */
	public void close() {
		try {
			this.workbook.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

		try {
			if (is != null) is.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
