package team.bangbang.common.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

//************************************************************************
//系统名称：帮帮WEB开发辅助类库
//class名称：文件读取器
/**
 * 读取文件内容。本读取器仅仅适合读取小批量的文件数据，不能进行大文件的读取。<br>
 * 为了简便编码，读取方法内部打开和关闭文件输出流。
 *
 * @author 帮帮组
 * @version 1.0
 */
// ************************************************************************
public class FileReader {
	/* 文件 */
	private File file = null;

	/**
	 * 构造文件读取器
	 *
	 * @param strFile
	 *            文件名
	 * @throws IOException IO异常
	 */
	public FileReader(String strFile) throws IOException {
		file = new File(strFile);

		// 判断是否存在并且可读
		if (!file.exists() || file.isDirectory()) {
			throw new IOException("File not exist or is directory.");
		}
	}

	/**
	 * 构造文件读取器
	 *
	 * @param f
	 *            文件对象
	 * @throws IOException IO异常
	 */
	public FileReader(File f) throws IOException {
		file = f;

		// 判断是否存在并且可读
		if (!file.exists() || file.isDirectory()) {
			throw new IOException("File not exist or is directory.");
		}
	}

	/**
	 * 以文本形式读取文件内容，取得的内容使用系统默认的字符集
	 *
	 * @throws IOException IO异常
	 * @return 文件内容
	 * @throws IOException IO异常
	 */
	public String readString() throws IOException {
		return new String(readBytes());
	}

	/**
	 * 以文本形式读取文件内容，取得的内容使用指定的字符集
	 *
	 * @param charset
	 *            编码方式
	 *
	 * @return 文件内容
	 *
	 * @throws IOException IO异常
	 * @throws UnsupportedEncodingException 指定的字符集不支持
	 *
	 */
	public String readString(String charset)
			throws UnsupportedEncodingException, IOException {
		return new String(readBytes(), charset);
	}

	/**
	 * 以字节形式读取文件内容
	 *
	 * @return 文件内容
	 * @throws IOException IO异常
	 */
	public byte[] readBytes() throws IOException {
		int nLen = (int) file.length();
		byte[] byBuf = new byte[nLen];

		// read file
		FileInputStream reader = null;
		try {
			reader = new FileInputStream(file);
			reader.read(byBuf);
		} catch (IOException iex) {
			throw iex;
		} finally {
			try {
				if (reader != null)
					reader.close();
			} catch (Exception ex) {
			}
		}

		return byBuf;
	}
}
