package team.bangbang.common.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

//************************************************************************
//系统名称：帮帮WEB开发辅助类库
//class名称：文件写入器
/**
 * 指定文件名和追加方式，写入文本内容。在不指定追加方式的情况下，覆盖写入文本内容。<br>
 * 本写入器仅仅适合写入小批量的文本数据，不能进行大文件的写入、或者非文本格式文件的写入操作。 <br>
 * 为了简便编码，写入方法内部打开和关闭文件输入流。
 *
 * @author 帮帮组
 * @version 1.0
 */
// ************************************************************************
public class FileWriter {
	/* 文件 */
	private File file = null;

	/**
	 * 构造一个文件写入器，默认使用覆盖写入方式
	 *
	 * @param strFile
	 *            文件名
	 * @throws IOException IO异常
	 */
	public FileWriter(String strFile) throws IOException {
		file = new File(strFile);
		if (!file.exists())
			file.createNewFile();
	}

	/**
	 * 构造一个文件写入器，默认使用覆盖写入方式
	 *
	 * @param f
	 *            文件对象
	 * @throws IOException IO异常
	 */
	public FileWriter(File f) throws IOException {
		file = f;
		if (!file.exists())
			file.createNewFile();
	}

	/**
	 * 使用覆盖写方式写入文本文件内容
	 *
	 * @param content
	 *            文本文件内容
	 * @param charsetName
	 *            使用的字符集
	 * @throws IOException IO异常
	 */
	public void writeString(String content, String charsetName)
			throws IOException {
		writeString(content, charsetName, false);
	}

	/**
	 * 写入文本文件内容
	 *
	 * @param content
	 *            文本文件内容
	 * @param charsetName
	 *            使用的字符集
	 * @param blAppend
	 *            true: 追加写 false: 覆盖写
	 * @throws IOException IO异常
	 */
	public void writeString(String content, String charsetName, boolean blAppend)
			throws IOException {
		// write file
		OutputStreamWriter writer = null;
		try {
			writer = new OutputStreamWriter(
					new FileOutputStream(file, blAppend), charsetName);

			writer.write(content);
		} catch (IOException iex) {
			throw iex;
		} finally {
			try {
				if (writer != null)
					writer.close();
			} catch (Exception ex) {
			}
		}
	}

	/**
	 * 使用覆盖写方式写入文件内容
	 *
	 * @param byContent
	 *            文件内容
	 * @throws IOException IO异常
	 */
	public void writeBytes(byte[] byContent) throws IOException {
		writeBytes(byContent, false);
	}

	/**
	 * 写入文件内容
	 *
	 * @param byContent
	 *            文本内容
	 * @param blAppend
	 *            true: 追加写 false: 覆盖写
	 * @throws IOException IO异常
	 */
	public void writeBytes(byte[] byContent, boolean blAppend)
			throws IOException {
		// write file
		FileOutputStream writer = null;
		try {
			writer = new FileOutputStream(file, blAppend);
			writer.write(byContent);
		} catch (IOException iex) {
			throw iex;
		} finally {
			try {
				if (writer != null)
					writer.close();
			} catch (Exception ex) {
			}
		}
	}
}
