package team.bangbang.common.file;

import java.io.IOException;
import java.io.InputStream;

/**
 * 文件上传、下载处理器接口
 *
 * @author 帮帮组
 * @version 1.0 2016年3月19日
 */
public interface IFileManager {
	/**
	 * 文件上传
	 *
	 * @param localFile
	 *            本地文件名称，包括正确的名称和扩展名
	 * @param destSliceFile
	 *            目标文件片段，不含根目录前缀。
	 *
	 * @return 上传成功后的目标文件路径，可能是完全地址，也可能是短地址。短地址使用当前应用的stream?file=形式访问
	 *
	 * @throws IOException IO异常
	 */
	public String put(String localFile, String destSliceFile) throws IOException;

	/**
	 * 检查目标文件是否存在
	 *
	 * @param destSliceFile
	 *            目标文件片段，不含根目录前缀。
	 *
	 * @return true：存在  false：不存在
	 * @throws IOException IO异常
	 */
	public boolean exist(String destSliceFile) throws IOException;

	/**
	 * 文件下载
	 *
	 * @param destFile
	 *            目标文件名
	 *
	 * @return 文件内容输入流
	 *
	 * @throws IOException IO异常
	 */
	public InputStream get(String destFile) throws IOException;
}
