package team.bangbang.common.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import team.bangbang.common.config.Config;

/**
 * 将文件上传到服务器本地
 *
 * @author 帮帮组
 * @version 1.0 2016年3月19日
 */
public class LocalFileManager implements IFileManager {

	@Override
	public String put(String localFile, String destSliceFile) throws IOException {
		// 获得存放文件的目录
		String path = Config.getProperty("file.attachment.directory");
		if (path == null) {
			throw new IOException("在application.properties文件中没有配置" + "{file.attachment.directory}目录！");
		}

		path += "/" + destSliceFile;

		// 临时文件
		File _file = new File(localFile);

		File target = new File(path);
		if (target.getParentFile() != null && !target.getParentFile().exists()) {
			// 目录不存在，创建目录
			target.getParentFile().mkdirs();
		}

		boolean bl = FileUtil.moveFile(_file, target);
		if (bl) {
			// 文件移动成功，回写上传到服务端的文件名称
			return destSliceFile;
		}

		return "";
	}

	@Override
	public boolean exist(String destSliceFile) throws IOException {
		// 获得存放文件的目录
		String path = Config.getProperty("file.attachment.directory");
		if (path == null) {
			throw new IOException("在application.properties文件中没有配置" + "{file.attachment.directory}目录！");
		}

		path += "/" + destSliceFile;

		File f = new File(path);
		return f.exists();
	}

	@Override
	public InputStream get(String destFile) throws IOException {
		return null;
	}
}
