package team.bangbang.common.file;

import java.io.IOException;
import java.io.InputStream;

import team.bangbang.common.config.Config;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import team.bangbang.common.file.IFileManager;

/**
 * 七牛云文件上传、下载器
 *
 * @author 帮帮组
 * @version 1.0 2016年3月19日
 */
public class QiniuOssManager implements IFileManager {
	/* 账号的ACCESS_KEY */
	private final String ACCESS_KEY = Config.getProperty("file.attachment.manager.qiniu.accessKey");
	/* 账号的SECRET_KEY */
	private final String SECRET_KEY = Config.getProperty("file.attachment.manager.qiniu.secretKey");
	/* 上传的空间 */
	private final String BUCKET = Config.getProperty("file.attachment.manager.qiniu.bucket");
	/* 地址前缀 */
	private final String ROOT = Config.getProperty("file.attachment.manager.qiniu.root");

	/*
	 * (non-Javadoc)
	 *
	 * @see team.bangbang.common.file.IFileManager#put(java.lang.String,
	 * java.lang.String)
	 */
	@Override
	public String put(String localFile, String destSliceFile) throws IOException {
		// 密钥配置
		Auth auth = Auth.create(ACCESS_KEY, SECRET_KEY);
		// 创建上传对象
		UploadManager uploadManager = new UploadManager(new Configuration());

		// 简单上传，使用默认策略，只需要设置上传的空间名就可以了
		String token = auth.uploadToken(BUCKET);

		try {
			// 调用put方法上传
			Response res = uploadManager.put(localFile, destSliceFile, token);
			// 打印返回的信息
			System.out.println(res.body());
		} catch (QiniuException e) {
			Response r = e.response;
			// 请求失败时打印的异常的信息
			System.out.println(r.toString());
			try {
				// 响应的文本信息
				System.out.println(r.bodyString());
			} catch (QiniuException e1) {
				// ignore
			}
		}

		return ROOT + destSliceFile;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see team.bangbang.common.file.IFileManager#exist(java.lang.String)
	 */
	@Override
	public boolean exist(String destSliceFile) throws IOException {
		// TODO Auto-generated method stub
		return false;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see team.bangbang.common.file.IFileManager#get(java.lang.String)
	 */
	@Override
	public InputStream get(String destFile) throws IOException {
		// TODO Auto-generated method stub
		return null;
	}
}
