package team.bangbang.common.file;

import java.io.InputStream;
import java.util.List;

import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/**
 * 使用jdom解析XML
 *
 * @author 帮帮组
 * @version 1.0 2019-09-28
 */
public class XMLParser {
	/* XML输入流 */
	private InputStream is = null;
	/* 根元素 */
	private Element root = null;

	/**
	 * 构造一个XML解析器
	 *
	 * @param is XML输入流
	 * @throws Exception 异常
	 */
	public XMLParser(InputStream is) throws Exception {
		this.is = is;
		readDocument();
	}

	/**
	 * 读取XML文档，此方法必须执行，而后才可以执行文档解析。
	 * @throws Exception 异常
	 */
	private void readDocument() throws Exception {
		SAXBuilder sb = new SAXBuilder();
		root = sb.build(this.is).getRootElement();
	}

	/**
	 * 返回根节点
	 * @return 根节点
	 */
	public Element getRootElement() {
		return root;
	}

	/**
	 * 指定节点的值
	 * @param ele 指定节点
	 *
	 * @return 节点的值
	 */
	public static String getText(Element ele) {
		return (ele != null) ? ele.getText() : null;
	}

	/**
	 * 指定节点的属性值
	 * @param ele 指定节点
	 * @param name 属性名称
	 *
	 * @return 属性值
	 */
	public static String getAttributeValue(Element ele, String name) {

		return (ele != null) ? ele.getAttributeValue(name) : null;
	}

	/**
	 * 获得指定子节点
	 * @param ele 指定节点
	 * @param childTag 子节点标签
	 *
	 * @return 指定子节点
	 */
	public static Element getChild(Element ele, String childTag) {

		return (ele != null) ? ele.getChild(childTag) : null;
	}

	/**
	 * 指定节点的子节点列表
	 * @param ele 指定节点
	 * @return 子节点列表
	 */
	@SuppressWarnings("unchecked")
	public static List<Element> getChildren(Element ele) {
		return (ele != null) ? ele.getChildren() : null;
	}

	/**
	 * 指定节点的子节点列表
	 * @param ele 指定节点
	 * @param childTag 子节点标签
	 * @return 子节点列表
	 */
	@SuppressWarnings("unchecked")
	public static List<Element> getChildren(Element ele, String childTag) {
		return (ele != null) ? ele.getChildren(childTag) : null;
	}
}
