package team.bangbang.common.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;

import team.bangbang.common.config.Config;

//************************************************************************
//系统名称：帮帮WEB开发辅助类库
//class名称：字符编码Filter
/**
 * 设定Request的字符集，该Filter默认对*.do请求生效，其它请求通过web.xml加载生效。
 * <br>
 * 缺省字符集：UTF-8<br>
 *
 * <pre>
 *
 * |filter|
 *	 |init-param|
 *		|param-name|encoding|/param-name|
 *		|param-value|UTF-8|/param-value|
 *	 |/init-param|
 *	|/filter|
 *
 * </pre>
 *
 * @author 帮帮组
 * @version 1.0 2019-05-25
 */
// ************************************************************************
@WebFilter(filterName = "EncodingFilter", urlPatterns = "*.do")
public class EncodingFilter implements Filter {
	/* 当前filter是否启用，默认为false  */
	private final static boolean enable = Config.getProperty("filter.EncodingFilter.enable") != null && Config.getProperty("filter.EncodingFilter.enable").trim().equalsIgnoreCase("true");
	/* 缺省的字符编码格式("UTF-8) */
	private static final String DEFAULT_ENCODEING = "UTF-8";
	/* 声明字符编码格式变量 */
	private String encoding = null;

	/**
	 * 初始化方法
	 *
	 * @param argFilterConfig 过滤配置信息
	 * @exception ServletException Servlet 异常
	 *
	 * @see Filter#init(FilterConfig)
	 */
	public void init(FilterConfig argFilterConfig) throws ServletException {
		// 获得配置参数
		encoding = argFilterConfig.getInitParameter("encoding");
		if (encoding == null || "".equals(encoding)) {
			encoding = DEFAULT_ENCODEING;
		}
	}

	/**
	 * 销毁处理方法
	 *
	 * @see Filter#destroy()
	 */
	public void destroy() {
	}

	/**
	 * HTTP 请求字符编码过滤处理
	 *
	 * @param argRequest  ServletRequest
	 * @param argResponse ServletResponse
	 * @param argChain    FilterChain
	 * @exception IOException      数据流异常
	 * @exception ServletException servlet异常
	 *
	 * @see Filter#doFilter(ServletRequest,
	 *      ServletResponse, FilterChain)
	 */
	public void doFilter(ServletRequest argRequest, ServletResponse argResponse, FilterChain argChain)
			throws IOException, ServletException {
		if (!enable) {
			// 未启用filter，直接忽略
			argChain.doFilter(argRequest, argResponse);
			return;
		}

		// 编码设定处理
		argRequest.setCharacterEncoding(encoding);
		argChain.doFilter(argRequest, argResponse);
	}
}
