package team.bangbang.common.geo;

import team.bangbang.common.geo.GeoPoint;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/**
 * 地理位置工具类
 *
 * @author 帮帮组
 * @version 1.0  2019年7月26日
 */
public class GeoUtility {

    /**
     * 判断点是否在范围内
     *
     * @param location 指定的点位置
     * @param scopeList 范围多边形的点范围
     *
     * @return true：在范围内 false：在范围之外
     */
    public static boolean isInScope(team.bangbang.common.geo.GeoPoint location, List<team.bangbang.common.geo.GeoPoint> scopeList) {
        Point2D.Double point = new Point2D.Double();
        point.setLocation(location.getLongitude(), location.getLatitude());

        List<Point2D.Double> polygon = new ArrayList<>();
        for (GeoPoint gp : scopeList) {
            Point2D.Double newPoint = new Point2D.Double();
            newPoint.setLocation(gp.getLongitude(), gp.getLatitude());
            polygon.add(newPoint);
        }

        java.awt.geom.GeneralPath p = new java.awt.geom.GeneralPath();
        Point2D.Double first = polygon.get(0);
        p.moveTo(first.x, first.y);
        for (Point2D.Double d : polygon) {
            p.lineTo(d.x, d.y);
        }
        p.lineTo(first.x, first.y);
        p.closePath();
        return p.contains(point);
    }
}
