package team.bangbang.common.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/**
 * 异常日志，将异常堆栈信息打印到日志中
 *
 * @author Bangbang
 * @version 1.0  2021年6月23日
 */
public class ExceptionLog {
	/* 日志对象 */
	private static final Logger logger = LoggerFactory.getLogger(ExceptionLog.class);

	/**
	 * 记录异常堆栈信息
	 * 
	 * @param th 异常信息
	 */
	public static void log(Throwable th) {
		 logger.error("异常信息", th);
	}
}
