package team.bangbang.common.log;

/**
 * 操作用户的日志
 *
 * @author 帮帮组
 * @version 1.0 2018-9-28
 */
public class OperationLog {
    /* 必填，操作人名称 */
    private String userName = null;
    /* 必填，操作类型，可以是：新增、修改、删除、同步等等 */
    private String type = null;
    /* 必填，业务数据，包含唯一标识ID */
    private Object bizData = null;

    /**
     * 构建一个空的操作用户的日志
     */
    public OperationLog() {
    }

    /**
     * 使用参数构建一个空的操作用户的日志
     *
     * @param userName 操作人名称
     * @param type 操作类型，可以是：新增、修改、删除、同步等等
     * @param bizData 业务数据，包含唯一标识ID
     */
    public OperationLog(String userName, String type, Object bizData) {
        this.userName = userName;
        this.type = type;
        this.bizData = bizData;
    }

    /**
     * @return 操作人名称
     */
    public String getUserName() {
        return userName;
    }

    /**
     * @param userName 操作人名称
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * @return 操作类型，可以是：新增、修改、删除、同步等等
     */
    public String getType() {
        return type;
    }

    /**
     * @param type 操作类型，可以是：新增、修改、删除、同步等等
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @return 业务数据，包含唯一标识ID
     */
    public Object getBizData() {
        return bizData;
    }

    /**
     * @param bizData 业务数据，包含唯一标识ID
     */
    public void setBizData(Object bizData) {
        this.bizData = bizData;
    }
}
