package team.bangbang.common.log;

import com.alibaba.fastjson.JSONObject;

/**
 * Restful接口的日志数据
 *
 * @author 帮帮组
 * @version 1.0 2018-9-28
 */
public class RestfulLog {
    /* 必填，⽇志标识（不可重复，使⽤36位uuid) */
    private String logId = null;
    /* 必填，状态码，对应 StatusCode.XXXX 的值 */
    private int statusCode = 0;
    /* 必填，请求IP */
    private String requestIP = null;
    /* 必填，请求时间，格式为：yyyy-MM-dd HH:mm:ss */
    private String requestTime = null;
    /* 选填，操作⼈编号 */
    private String userId = null;
    /* 选填，操作人名称 */
    private String userName = null;
    /* 选填，请求参数 */
    private JSONObject requestData = null;
    /* 选填，响应结果 */
    private String responseData = null;
    /* 必填，请求处理的时⻓，单位：毫秒 */
    private int dealTime = 0;

    /**
     * @return 必填，请求IP
     */
    public String getRequestIP() {
        return requestIP;
    }

    /**
     * @param requestIP 必填，请求IP
     */
    public void setRequestIP(String requestIP) {
        this.requestIP = requestIP;
    }

    /**
     * @return 必填，请求时间，格式为：yyyy-MM-dd HH:mm:ss
     */
    public String getRequestTime() {
        return requestTime;
    }

    /**
     * @param requestTime 必填，请求时间，格式为：yyyy-MM-dd HH:mm:ss
     */
    public void setRequestTime(String requestTime) {
        this.requestTime = requestTime;
    }

    /**
     * @return 选填，请求参数
     */
    public JSONObject getRequestData() {
        return requestData;
    }

    /**
     * @param requestData 选填，请求参数
     */
    public void setRequestData(JSONObject requestData) {
        this.requestData = requestData;
    }

    /**
     * @return 选填，响应结果
     */
    public String getResponseData() {
        return responseData;
    }

    /**
     * @param responseData 选填，响应结果
     */
    public void setResponseData(String responseData) {
        this.responseData = responseData;
    }

    /**
     * @return 必填，请求处理的时⻓，单位：毫秒
     */
    public int getDealTime() {
        return dealTime;
    }

    /**
     * @param dealTime 必填，请求处理的时⻓，单位：毫秒
     */
    public void setDealTime(int dealTime) {
        this.dealTime = dealTime;
    }
    /**
     * @return 必填，⽇志标识（不可重复，使⽤36位uuid)
     */
    public String getLogId() {
        return logId;
    }

    /**
     * @param logId 必填，⽇志标识（不可重复，使⽤36位uuid)
     */
    public void setLogId(String logId) {
        this.logId = logId;
    }

    /**
     * @return 必填，状态码，对应 StatusCode.XXXX 的值
     */
    public int getStatusCode() {
        return statusCode;
    }

    /**
     * @param statusCode 必填，状态码，对应 StatusCode.XXXX 的值
     */
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    /**
     * @return 操作⼈编号
     */
    public String getUserId() {
        return userId;
    }

    /**
     * @param userId 操作⼈编号
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * @return 操作人名称
     */
    public String getUserName() {
        return userName;
    }

    /**
     * @param userName 操作人名称
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }
}
