package team.bangbang.common.net.ftp;

/**
 * FTP过程中Ftp实例向宿主实例汇报的内容，约1秒汇报一次。
 *
 * @author 帮帮组
 */
public class FtpInformation {
	public final static int UPLOAD = 1;
	public final static int DOWNLOAD = 2;
	/* 上传/下载标志 */
	private int flag = 0;
	/* 传输速率(B/S) */
	private int speed = 0;
	/* 传输文件字节大小 */
	private long fileSize = 0L;
	/* 已经传输的文件字节大小 */
	private long completeSize = 0L;

	/**
	 * @return 已经传输的文件字节大小
	 */
	public long getCompleteSize() {
		return completeSize;
	}

	/**
	 * @param completeSize
	 *            已经传输的文件字节大小
	 */
	public void setCompleteSize(long completeSize) {
		this.completeSize = completeSize;
	}

	/**
	 * @return 上传/下载标志
	 */
	public int getFlag() {
		return flag;
	}

	/**
	 * @param flag
	 *            上传/下载标志
	 */
	public void setFlag(int flag) {
		this.flag = flag;
	}

	/**
	 * @return 传输文件字节大小
	 */
	public long getFileSize() {
		return fileSize;
	}

	/**
	 * @param fileSize
	 *            传输文件字节大小
	 */
	public void setFileSize(long fileSize) {
		this.fileSize = fileSize;
	}

	/**
	 * @return 剩余文件字节大小
	 */
	public long getLeftSize() {
		return fileSize - completeSize;
	}

	/**
	 * @return 传输速率(B/S)
	 */
	public int getSpeed() {
		return speed;
	}

	/**
	 * @param speed
	 *            传输速率(B/S)
	 */
	public void setSpeed(int speed) {
		this.speed = speed;
	}
}
