package team.bangbang.common.payment;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 整个在线支付分为3个部分：
 * 1. 订单实体信息
 * 在线支付订单实体信息
 *
 * @author 帮帮组
 * @version 1.0 2015-02-09
 */
public class Bill {
	/** 支付单号 */
	public String payNo = "";
	/** 买家名称 */
	public String buyerName = "";
	/** 商品名称 */
	public String goodsName = "";
	/** 交易金额(单位：分) */
	public Integer amount = 0;
	/** 备注信息 */
	public String memo = "";
	/** 交易时间 */
	public Date payTime = null;
	/*********************************************************************/
	/** 其它附加数据 */
	public Map<String, Object> restData = new HashMap<String, Object>();

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((payNo == null) ? 0 : payNo.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Bill other = (Bill) obj;
		if (payNo == null) {
			if (other.payNo != null)
				return false;
		} else if (!payNo.equals(other.payNo))
			return false;
		return true;
	}
}
