package team.bangbang.common.payment;

import team.bangbang.common.exception.BizException;

/**
 * 处理支付通知信息
 *
 * @author 帮帮组
 * @version 1.0 2020-06-12
 */
public interface IMessageHandler {
	/**
	 * 支付成功，根据通知信息处理订单
	 *
	 * @param conn            数据库操作对象，使用Object类型兼顾不同数据库的数据库封装
	 * @param bill            订单信息
	 *
	 * @return 处理是否成功
	 * @throws BizException 逻辑异常
	 */
	public boolean onPaySuccess(Object conn, team.bangbang.common.payment.Bill bill) throws BizException;

	/**
	 * 支付失败，根据通知信息处理订单
	 *
	 * @param conn            数据库操作对象，使用Object类型兼顾不同数据库的数据库封装
	 * @param bill            订单信息
	 *
	 * @return 处理是否成功
	 * @throws BizException 逻辑异常
	 */
	public boolean onPayFailure(Object conn, team.bangbang.common.payment.Bill bill) throws BizException;

	/**
	 * 退款成功，根据通知信息处理订单
	 *
	 * @param conn            数据库操作对象，使用Object类型兼顾不同数据库的数据库封装
	 * @param bill            订单信息
	 *
	 * @return 处理是否成功
	 * @throws BizException 逻辑异常
	 */
	public boolean onRefundSuccess(Object conn, team.bangbang.common.payment.Bill bill) throws BizException;

	/**
	 * 退款失败，根据通知信息处理订单
	 *
	 * @param conn            数据库操作对象，使用Object类型兼顾不同数据库的数据库封装
	 * @param bill            订单信息
	 *
	 * @return 处理是否成功
	 * @throws BizException 逻辑异常
	 */
	public boolean onRefundFailure(Object conn, Bill bill) throws BizException;
}
