package team.bangbang.common.payment;


import team.bangbang.common.payment.Bill;

/**
 * 在线支付的请求响应接口
 *
 * @author 帮帮组
 * @version 1.0  2013-06-05
 */
public interface IPaymentReceiver {
	/**
	 * 交易类型
	 */
    public enum TransactionType {
    	// 付款
    	Buy,
    	// 退款
    	Refund
    }

	/**
	 * 关联的在线支付订单实体信息
	 *
	 * @return 在线支付订单实体信息
	 */
	public Bill getBill();

	/**
	 * @return 请求是否合法
	 */
	public boolean verify();

	/**
	 * @return 交易结果是否成功
	 */
	public boolean isSuccess();

	/**
	 * @return 返回给第三方支付平台的结果
	 */
	public String getMessage();

	/**
	 * @return 交易类型
	 */
	public TransactionType getTransactionType();
}
