package team.bangbang.common.payment;


import team.bangbang.common.payment.Bill;

/**
 * 在线支付的请求提交接口
 *
 * @author 帮帮组
 * @version 1.0  2015-02-09
 */
public interface IPaymentSender {
	/**
	 * 设置订单信息
	 *
	 * @param bill 订单信息
	 */
	public void setBill(Bill bill);

	/**
	 * 获取在线支付HTML表单或者调用脚本
	 *
	 * @return 在线支付HTML表单或者调用脚本
	 */
	public String getPayFormScript();

	/**
	 * 退款
	 *
	 * @return 为null时表示成功，其它表示错误结果。
	 */
	public String refund();
}
