package team.bangbang.common.queue;

import team.bangbang.common.queue.Publisher;
import team.bangbang.common.queue.Subscriber;

/**
 * 队列管理者
 *
 * @author 帮帮组
 * @version 1.0  2018年9月30日
 */
public interface IQueueManager {

	/**
	 * 创建一个发布者
	 *
	 * @param topic 订阅主题
	 *
	 * @return 一个发布者
	 */
	public Publisher createPublisher(String topic);

	/**
	 * 登记一个订阅者
	 *
	 * @param subscriber 订阅者
	 *
	 * @return 一个队列消费者
	 */
	public boolean subscribe(team.bangbang.common.queue.Subscriber subscriber);

	/**
	 * 删除一个订阅者
	 *
	 * @param subscriber 订阅者
	 *
	 * @return 删除是否成功
	 */
	public boolean remove(Subscriber subscriber);
}
