package team.bangbang.common.queue;

/**
 * 队列消息
 *
 * @author 帮帮组
 * @version 1.0  2018年10月3日
 *
 * @param <T> 业务数据类型
 */
public class Message<T> {
	/* 队列元素编号，36位UUID字符串 */
	private String id = null;
	/* 发送时间，长整型 */
	private long sendTime = 0L;
	/* 队列topic名称 */
	private String topic = null;
	/* 发送者名称 */
	private String sender = null;
	/* 业务类型，包括{新增、修改、删除、同步} */
	private String type = null;
	/* 业务数据 */
	private T data = null;
	/**
	 * @return 队列元素编号，36位UUID字符串
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id 队列元素编号，36位UUID字符串
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * @return 发送时间，长整型
	 */
	public long getSendTime() {
		return sendTime;
	}
	/**
	 * @param sendTime 发送时间，长整型
	 */
	public void setSendTime(long sendTime) {
		this.sendTime = sendTime;
	}
	/**
	 * @return 队列topic名称
	 */
	public String getTopic() {
		return topic;
	}
	/**
	 * @param topic 队列topic名称
	 */
	public void setTopic(String topic) {
		this.topic = topic;
	}
	/**
	 * @return 发送者名称
	 */
	public String getSender() {
		return sender;
	}
	/**
	 * @param sender 发送者名称
	 */
	public void setSender(String sender) {
		this.sender = sender;
	}
	/**
	 * @return 业务类型，包括{新增、修改、删除、同步}
	 */
	public String getType() {
		return type;
	}
	/**
	 * @param type 业务类型，包括{新增、修改、删除、同步}
	 */
	public void setType(String type) {
		this.type = type;
	}
	/**
	 * @return 业务数据
	 */
	public T getData() {
		return data;
	}
	/**
	 * @param data 业务数据
	 */
	public void setData(T data) {
		this.data = data;
	}
}
