package team.bangbang.common.queue;

import team.bangbang.common.queue.Message;

/**
 * 队列发布者
 *
 * @author 帮帮组
 * @version 1.0 2018年9月30日
 */
public abstract class Publisher {
	/* 队列资源，使用该资源发布消息 */
	protected Object resource = null;
	/* 消息topic */
	private String topic = null;

	/**
	 * 构造一个队列发布者
	 *
	 * @param resource 队列资源
	 * @param topic 队列topic
	 */
	public Publisher(Object resource, String topic) {
		this.resource = resource;
		this.topic = topic;
	}

	/**
	 * @return 消息topic
	 */
	public String getTopic() {
		return topic;
	}

	/**
	 * @param topic 消息topic
	 */
	public void setTopic(String topic) {
		this.topic = topic;
	}

	/**
	 * @param message 发布一条消息
	 */
	public abstract void send(Message<?> message);
}
