package team.bangbang.common.queue;

import com.alibaba.fastjson.JSONObject;

/**
 * 队列订阅者
 *
 * @author 帮帮组
 * @version 1.0  2018年9月30日
 */
public abstract class Subscriber {
	/* 消息topic */
	private String topic = null;
	/* 订阅者在当前topic下的序号 */
	private int index = 0;

	/**
	 * 构造一个队列订阅者
	 *
	 * @param topic 队列topic
	 * @param index 订阅序号。同一topic下，序号不可重复
	 */
	public Subscriber(String topic, int index) {
		this.topic = topic;
		this.index = index;
	}

	/**
	 * @return 订阅者在当前topic下的序号
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * @return 消息topic
	 */
	public String getTopic() {
		return topic;
	}

	/**
	 * @param topic 消息topic
	 */
	public void setTopic(String topic) {
		this.topic = topic;
	}

	/**
	 * 消费一个队列数据
	 *
	 * @param json 消息数据，消息数据对象序列化形成的JSON数据
	 * @return 是否消费成功
	 */
	public abstract boolean consume(JSONObject json);
}
