package team.bangbang.common.queue.kafka;

import java.util.UUID;

import team.bangbang.common.queue.Message;
import team.bangbang.common.queue.Publisher;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

import com.alibaba.fastjson.JSONObject;

/**
 * Kafka队列发布者
 *
 * @author 帮帮组
 * @version 1.0 2018年10月1日
 */
public class KafkaPublisher extends Publisher {

	/**
	 * 构造一个队列发布者
	 *
	 * @param resource 队列资源
	 * @param topic    消息topic
	 */
	public KafkaPublisher(Object resource, String topic) {
		super(resource, topic);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see team.bangbang.common.queue.Publisher#send(team.bangbang.common.queue.Message
	 * message)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void send(Message<?> message) {
		if (message == null) {
			return;
		}

		// 填写id、sendTime、topic
		message.setId(UUID.randomUUID().toString());
		message.setSendTime(System.currentTimeMillis());
		message.setTopic(getTopic());

		Producer<String, String> producer = (Producer<String, String>) this.resource;

		if (producer == null) {
			return;
		}

		String strMsg = JSONObject.toJSONString(message);

		ProducerRecord<String, String> record = new ProducerRecord<String, String>(getTopic(), strMsg);

		// 发送消息
		producer.send(record);

		producer.flush();
	}
}
