package team.bangbang.common.queue.rabbit;

import java.io.IOException;
import java.util.UUID;

import com.alibaba.fastjson.JSONObject;
import team.bangbang.common.queue.Message;
import team.bangbang.common.queue.Publisher;
import com.rabbitmq.client.Channel;
import team.bangbang.common.queue.rabbit.RabbitManager;

/**
 * Rabbit队列发布者
 *
 * @author 帮帮组
 * @version 1.0 2018年9月30日
 */
public class RabbitPublisher extends Publisher {

	/**
	 * 构造一个队列发布者
	 *
	 * @param resource 队列资源
	 * @param topic 消息topic
	 */
	public RabbitPublisher(Object resource, String topic) {
		super(resource, topic);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see team.bangbang.common.queue.Publisher#send(team.bangbang.common.queue.Message message)
	 */
	@Override
	public void send(Message<?> message) {
		if (message == null) {
			return;
		}

		// 填写id、sendTime、topic
		message.setId(UUID.randomUUID().toString());
		message.setSendTime(System.currentTimeMillis());
		message.setTopic(getTopic());

		try {
			Channel channel = (Channel) this.resource;

			if (channel == null || !channel.isOpen()) {
				return;
			}

			String strMsg = JSONObject.toJSONString(message);

			String exchangeName = RabbitManager.getExchangeName(getTopic());

			// 发送消息
			// fanout：表示采用发布订阅模式
			channel.basicPublish(exchangeName, "fanout", null, strMsg.getBytes());
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
