package team.bangbang.common.queue.rabbit.pool;

import team.bangbang.common.queue.rabbit.pool.RabbitPoolFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;

/**
 * Rabbit队列连接池
 *
 * @author 帮帮组
 * @version 1.0 2018-9-30
 */
public class RabbitPool {
    /* 连接池 */
    private static GenericObjectPool<Connection> objectPool = null;

    static {
        RabbitPoolFactory factory = new RabbitPoolFactory();
        GenericObjectPoolConfig<Connection> config = new GenericObjectPoolConfig<Connection>();

        // 池对象最大数量
        config.setMaxTotal(50);
        // 最大空闲数量
        config.setMaxIdle(20);
        // 最小空闲数量
        config.setMinIdle(5);
        //取消连接对象过期不使用关闭策略
        config.setMinEvictableIdleTimeMillis(-1L);
        config.setSoftMinEvictableIdleTimeMillis(-1L);
        // 空闲对象检测线程的执行周期，即多长时候执行一次空闲对象检测。单位是毫秒数。如果小于等于0，则不执行检测线程。默认值是-1
        // 设置为 1 分钟执行一次
        config.setTimeBetweenEvictionRunsMillis(60000);

        objectPool = new GenericObjectPool<Connection>(factory, config);
    }

    /**
     * @return Rabbit队列channel
     */
    public Channel getChannel() {
        if(objectPool == null) return null;

        try {
            Connection conn = objectPool.borrowObject();

            Channel ch = conn.createChannel();

            objectPool.returnObject(conn);

            return ch;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }
}
